/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListServicesRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<ListServicesRequest.Builder, ListServicesRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final List<ServiceFilter> filters;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * For the first <code>ListServices</code> request, omit this value.
     * </p>
     * <p>
     * If more than <code>MaxResults</code> services match the specified criteria, you can submit another
     * <code>ListServices</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return For the first <code>ListServices</code> request, omit this value.</p>
     *         <p>
     *         If more than <code>MaxResults</code> services match the specified criteria, you can submit another
     *         <code>ListServices</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of services that you want Amazon Route 53 to return in the response to a
     * <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53
     * returns up to 100 services.
     * </p>
     * 
     * @return The maximum number of services that you want Amazon Route 53 to return in the response to a
     *         <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon Route
     *         53 returns up to 100 services.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A complex type that contains specifications for the namespaces that you want to list services for.
     * </p>
     * <p>
     * If you specify more than one filter, an operation must match all filters to be returned by
     * <code>ListServices</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains specifications for the namespaces that you want to list services for. </p>
     *         <p>
     *         If you specify more than one filter, an operation must match all filters to be returned by
     *         <code>ListServices</code>.
     */
    public List<ServiceFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filters(), other.filters());
    }

    @Override
    public String toString() {
        return ToString.builder("ListServicesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, CopyableBuilder<Builder, ListServicesRequest> {
        /**
         * <p>
         * For the first <code>ListServices</code> request, omit this value.
         * </p>
         * <p>
         * If more than <code>MaxResults</code> services match the specified criteria, you can submit another
         * <code>ListServices</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        For the first <code>ListServices</code> request, omit this value.</p>
         *        <p>
         *        If more than <code>MaxResults</code> services match the specified criteria, you can submit another
         *        <code>ListServices</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of services that you want Amazon Route 53 to return in the response to a
         * <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53
         * returns up to 100 services.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of services that you want Amazon Route 53 to return in the response to a
         *        <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon
         *        Route 53 returns up to 100 services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the namespaces that you want to list services for.
         *        </p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListServices</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ServiceFilter> filters);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the namespaces that you want to list services for.
         *        </p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListServices</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ServiceFilter... filters);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ServiceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ServiceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ServiceFilter>)
         */
        Builder filters(Consumer<ServiceFilter.Builder>... filters);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<ServiceFilter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<ServiceFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ServiceFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ServiceFilter> filters) {
            this.filters = ServiceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ServiceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ServiceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ServiceFilter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ServiceFilter.BuilderImpl> filters) {
            this.filters = ServiceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }
    }
}
