/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The namespace that you're trying to create already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NamespaceAlreadyExistsException extends ServiceDiscoveryException implements
        ToCopyableBuilder<NamespaceAlreadyExistsException.Builder, NamespaceAlreadyExistsException> {
    private final String creatorRequestId;

    private final String namespaceId;

    private NamespaceAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.creatorRequestId = builder.creatorRequestId;
        this.namespaceId = builder.namespaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The <code>CreatorRequestId</code> that was used to create the namespace.
     * </p>
     * 
     * @return The <code>CreatorRequestId</code> that was used to create the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the existing namespace.
     * </p>
     * 
     * @return The ID of the existing namespace.
     */
    public String namespaceId() {
        return namespaceId;
    }

    public interface Builder extends CopyableBuilder<Builder, NamespaceAlreadyExistsException> {
        /**
         * <p>
         * The <code>CreatorRequestId</code> that was used to create the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        The <code>CreatorRequestId</code> that was used to create the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the existing namespace.
         * </p>
         * 
         * @param namespaceId
         *        The ID of the existing namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String creatorRequestId;

        private String namespaceId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceAlreadyExistsException model) {
            creatorRequestId(model.creatorRequestId);
            namespaceId(model.namespaceId);
            this.message = model.getMessage();
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @JsonProperty("CreatorRequestId")
        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @JsonProperty("NamespaceId")
        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public NamespaceAlreadyExistsException build() {
            return new NamespaceAlreadyExistsException(this);
        }
    }
}
