/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.servicediscovery.transform.OperationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Operation implements StructuredPojo, ToCopyableBuilder<Operation.Builder, Operation> {
    private final String id;

    private final String type;

    private final String status;

    private final String errorMessage;

    private final String errorCode;

    private final Instant createDate;

    private final Instant updateDate;

    private final Map<String, String> targets;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * The ID of the operation that you want to get information about.
     * </p>
     * 
     * @return The ID of the operation that you want to get information about.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the operation that is associated with the specified ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the operation that is associated with the specified ID.
     * @see OperationType
     */
    public OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The name of the operation that is associated with the specified ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the operation that is associated with the specified ID.
     * @see OperationType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: Amazon Route 53 is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: Amazon Route 53 is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: Amazon Route 53 is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: Amazon Route 53 is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
     * </p>
     * 
     * @return If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The code associated with <code>ErrorMessage</code>.
     * </p>
     * 
     * @return The code associated with <code>ErrorMessage</code>.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time
     *         (UTC).
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
     * and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time
     *         format and Coordinated Universal Time (UTC).
     */
    public Instant updateDate() {
        return updateDate;
    }

    /**
     * <p>
     * The name of the target entity that is associated with the operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name of the target entity that is associated with the operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     */
    public Map<OperationTargetType, String> targets() {
        return TypeConverter.convert(targets, OperationTargetType::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, OperationTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * The name of the target entity that is associated with the operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The name of the target entity that is associated with the operation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </li>
     */
    public Map<String, String> targetsAsStrings() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(targetsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(updateDate(), other.updateDate())
                && Objects.equals(targetsAsStrings(), other.targetsAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("Operation").add("Id", id()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("ErrorCode", errorCode()).add("CreateDate", createDate())
                .add("UpdateDate", updateDate()).add("Targets", targetsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Type":
            return Optional.of(clazz.cast(typeAsString()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.of(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.of(clazz.cast(errorCode()));
        case "CreateDate":
            return Optional.of(clazz.cast(createDate()));
        case "UpdateDate":
            return Optional.of(clazz.cast(updateDate()));
        case "Targets":
            return Optional.of(clazz.cast(targetsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The ID of the operation that you want to get information about.
         * </p>
         * 
         * @param id
         *        The ID of the operation that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the operation that is associated with the specified ID.
         * </p>
         * 
         * @param type
         *        The name of the operation that is associated with the specified ID.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the operation that is associated with the specified ID.
         * </p>
         * 
         * @param type
         *        The name of the operation that is associated with the specified ID.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: Amazon Route 53 is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: Amazon Route 53 is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: Amazon Route 53 is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: Amazon Route 53 is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
         * </p>
         * 
         * @param errorMessage
         *        If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The code associated with <code>ErrorMessage</code>.
         * </p>
         * 
         * @param errorCode
         *        The code associated with <code>ErrorMessage</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param createDate
         *        The date and time that the request was submitted, in Unix date/time format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time
         * format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param updateDate
         *        The date and time that the value of <code>Status</code> changed to the current value, in Unix
         *        date/time format and Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);

        /**
         * <p>
         * The name of the target entity that is associated with the operation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param targets
         *        The name of the target entity that is associated with the operation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE</b>: The namespace ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE</b>: The service ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>INSTANCE</b>: The instance ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, String> targets);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private String errorMessage;

        private String errorCode;

        private Instant createDate;

        private Instant updateDate;

        private Map<String, String> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            id(model.id);
            type(model.type);
            status(model.status);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            createDate(model.createDate);
            updateDate(model.updateDate);
            targets(model.targets);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Map<String, String> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}
