/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.OperationSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about an operation that matches the criteria that you specified in a
 * <a>ListOperations</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationSummary implements StructuredPojo, ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private final String id;

    private final String status;

    private OperationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID for an operation.
     * </p>
     * 
     * @return The ID for an operation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: Amazon Route 53 is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: Amazon Route 53 is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: Amazon Route 53 is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: Amazon Route 53 is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationSummary").add("Id", id()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * The ID for an operation.
         * </p>
         * 
         * @param id
         *        The ID for an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: Amazon Route 53 is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: Amazon Route 53 is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: Amazon Route 53 is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: Amazon Route 53 is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            id(model.id);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }
    }
}
