/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.DnsPropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsProperties implements StructuredPojo, ToCopyableBuilder<DnsProperties.Builder, DnsProperties> {
    private final String hostedZoneId;

    private DnsProperties(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
     * </p>
     * 
     * @return The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsProperties)) {
            return false;
        }
        DnsProperties other = (DnsProperties) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    @Override
    public String toString() {
        return ToString.builder("DnsProperties").add("HostedZoneId", hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DnsProperties> {
        /**
         * <p>
         * The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID for the hosted zone that Amazon Route 53 creates when you create a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsProperties model) {
            hostedZoneId(model.hostedZoneId);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public DnsProperties build() {
            return new DnsProperties(this);
        }
    }
}
