/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.DnsRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when
 * you register an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsRecord implements StructuredPojo, ToCopyableBuilder<DnsRecord.Builder, DnsRecord> {
    private final String type;

    private final Long ttl;

    private DnsRecord(BuilderImpl builder) {
        this.type = builder.type;
        this.ttl = builder.ttl;
    }

    /**
     * <p>
     * The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. The
     * following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
     * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the following
     * template, which can't be changed:
     * </p>
     * <p>
     * <code>priority weight port resource-record-set-name</code>
     * </p>
     * <p>
     * The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes from the
     * value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS
     *         queries. The following values are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
     *         2001:0db8:85a3:0000:0000:abcd:0001:2345.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
     *         following template, which can't be changed:
     *         </p>
     *         <p>
     *         <code>priority weight port resource-record-set-name</code>
     *         </p>
     *         <p>
     *         The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes
     *         from the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
     *         </p>
     *         </li>
     * @see RecordType
     */
    public RecordType type() {
        return RecordType.fromValue(type);
    }

    /**
     * <p>
     * The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. The
     * following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
     * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the following
     * template, which can't be changed:
     * </p>
     * <p>
     * <code>priority weight port resource-record-set-name</code>
     * </p>
     * <p>
     * The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes from the
     * value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS
     *         queries. The following values are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
     *         2001:0db8:85a3:0000:0000:abcd:0001:2345.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
     *         following template, which can't be changed:
     *         </p>
     *         <p>
     *         <code>priority weight port resource-record-set-name</code>
     *         </p>
     *         <p>
     *         The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes
     *         from the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
     *         </p>
     *         </li>
     * @see RecordType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
     * </p>
     * 
     * @return The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource
     *         record set.
     */
    public Long ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord other = (DnsRecord) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(ttl(), other.ttl());
    }

    @Override
    public String toString() {
        return ToString.builder("DnsRecord").add("Type", typeAsString()).add("TTL", ttl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TTL":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DnsRecord> {
        /**
         * <p>
         * The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries.
         * The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
         * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
         * following template, which can't be changed:
         * </p>
         * <p>
         * <code>priority weight port resource-record-set-name</code>
         * </p>
         * <p>
         * The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes from
         * the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS
         *        queries. The following values are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
         *        2001:0db8:85a3:0000:0000:abcd:0001:2345.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
         *        following template, which can't be changed:
         *        </p>
         *        <p>
         *        <code>priority weight port resource-record-set-name</code>
         *        </p>
         *        <p>
         *        The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes
         *        from the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a>
         *        request.
         *        </p>
         *        </li>
         * @see RecordType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries.
         * The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
         * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
         * following template, which can't be changed:
         * </p>
         * <p>
         * <code>priority weight port resource-record-set-name</code>
         * </p>
         * <p>
         * The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes from
         * the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a> request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS
         *        queries. The following values are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A</b>: Amazon Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AAAA</b>: Amazon Route 53 returns the IP address of the resource in IPv6 format, such as
         *        2001:0db8:85a3:0000:0000:abcd:0001:2345.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SRV</b>: Amazon Route 53 returns the value for an SRV record. The value for an SRV record uses the
         *        following template, which can't be changed:
         *        </p>
         *        <p>
         *        <code>priority weight port resource-record-set-name</code>
         *        </p>
         *        <p>
         *        The values of <code>priority</code> and <code>weight</code> are both set to 1. The value of port comes
         *        from the value that you specify for <code>Port</code> when you submit a <a>RegisterInstance</a>
         *        request.
         *        </p>
         *        </li>
         * @see RecordType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordType
         */
        Builder type(RecordType type);

        /**
         * <p>
         * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record
         * set.
         * </p>
         * 
         * @param ttl
         *        The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource
         *        record set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Long ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRecord model) {
            type(model.type);
            ttl(model.ttl);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecordType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getTTL() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public DnsRecord build() {
            return new DnsRecord(this);
        }
    }
}
