/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetInstanceResponse.Builder, GetInstanceResponse> {
    private final Instance instance;

    private GetInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instance = builder.instance;
    }

    /**
     * <p>
     * A complex type that contains information about a specified instance.
     * </p>
     * 
     * @return A complex type that contains information about a specified instance.
     */
    public Instance instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceResponse)) {
            return false;
        }
        GetInstanceResponse other = (GetInstanceResponse) obj;
        return Objects.equals(instance(), other.instance());
    }

    @Override
    public String toString() {
        return ToString.builder("GetInstanceResponse").add("Instance", instance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, GetInstanceResponse> {
        /**
         * <p>
         * A complex type that contains information about a specified instance.
         * </p>
         * 
         * @param instance
         *        A complex type that contains information about a specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(Instance instance);

        /**
         * <p>
         * A complex type that contains information about a specified instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Instance.Builder} avoiding the need to create
         * one manually via {@link Instance#builder()}.
         *
         * When the {@link Consumer} completes, {@link Instance.Builder#build()} is called immediately and its result is
         * passed to {@link #instance(Instance)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link Instance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(Instance)
         */
        default Builder instance(Consumer<Instance.Builder> instance) {
            return instance(Instance.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Instance instance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceResponse model) {
            super(model);
            instance(model.instance);
        }

        public final Instance.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        @Override
        public final Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public final void setInstance(Instance.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        public GetInstanceResponse build() {
            return new GetInstanceResponse(this);
        }
    }
}
