/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.HealthCheckConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If you specify
 * settings for a health check, Amazon Route 53 associates the health check with all the resource record sets that you
 * specify in <code>DnsConfig</code>.
 * </p>
 * <note>
 * <p>
 * The health check uses 30 seconds as the request interval. This is the number of seconds between the time that each
 * Amazon Route 53 health checker gets a response from your endpoint and the time that it sends the next health check
 * request. A health checker in each data center around the world sends your endpoint a health check request every 30
 * seconds. On average, your endpoint receives a health check request about every two seconds. Health checkers in
 * different data centers don't coordinate with one another, so you'll sometimes see several requests per second
 * followed by a few seconds with no health checks at all.
 * </p>
 * </note>
 * <p>
 * For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing">Amazon Route
 * 53 Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckConfig implements StructuredPojo, ToCopyableBuilder<HealthCheckConfig.Builder, HealthCheckConfig> {
    private final String type;

    private final String resourcePath;

    private final Integer failureThreshold;

    private HealthCheckConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.failureThreshold = builder.failureThreshold;
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
     * endpoint is healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an HTTP
     * request and waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
     * HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Amazon Route 53 determines whether
     *         an endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits
     *         an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits
     *         an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.
     * @see HealthCheckType
     */
    public HealthCheckType type() {
        return HealthCheckType.fromValue(type);
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
     * endpoint is healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an HTTP
     * request and waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
     * HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Amazon Route 53 determines whether
     *         an endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits
     *         an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits
     *         an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.
     * @see HealthCheckType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for
     * which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, such as the file
     * <code>/docs/route53-health-check.html</code>. Amazon Route 53 automatically adds the DNS name for the service and
     * a leading forward slash (<code>/</code>) character.
     * </p>
     * 
     * @return The path that you want Amazon Route 53 to request when performing health checks. The path can be any
     *         value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy,
     *         such as the file <code>/docs/route53-health-check.html</code>. Amazon Route 53 automatically adds the DNS
     *         name for the service and a leading forward slash (<code>/</code>) character.
     */
    public String resourcePath() {
        return resourcePath;
    }

    /**
     * <p>
     * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the
     * current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change
     *         the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.
     */
    public Integer failureThreshold() {
        return failureThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourcePath(), other.resourcePath())
                && Objects.equals(failureThreshold(), other.failureThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("HealthCheckConfig").add("Type", typeAsString()).add("ResourcePath", resourcePath())
                .add("FailureThreshold", failureThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourcePath":
            return Optional.ofNullable(clazz.cast(resourcePath()));
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HealthCheckConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheckConfig> {
        /**
         * <p>
         * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
         * endpoint is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
         * HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
         * HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         * Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Amazon Route 53 determines
         *        whether an endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53
         *        submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53
         *        submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
         * endpoint is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
         * HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53 submits an
         * HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         * Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Amazon Route 53 determines
         *        whether an endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53
         *        submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Amazon Route 53 tries to establish a TCP connection. If successful, Amazon Route 53
         *        submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Amazon Route 53 tries to establish a TCP connection.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(HealthCheckType type);

        /**
         * <p>
         * The path that you want Amazon Route 53 to request when performing health checks. The path can be any value
         * for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, such as
         * the file <code>/docs/route53-health-check.html</code>. Amazon Route 53 automatically adds the DNS name for
         * the service and a leading forward slash (<code>/</code>) character.
         * </p>
         * 
         * @param resourcePath
         *        The path that you want Amazon Route 53 to request when performing health checks. The path can be any
         *        value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is
         *        healthy, such as the file <code>/docs/route53-health-check.html</code>. Amazon Route 53 automatically
         *        adds the DNS name for the service and a leading forward slash (<code>/</code>) character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePath(String resourcePath);

        /**
         * <p>
         * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the
         * current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         * Guide</i>.
         * </p>
         * 
         * @param failureThreshold
         *        The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to
         *        change the current status of the endpoint from unhealthy to healthy or vice versa. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThreshold(Integer failureThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String resourcePath;

        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            type(model.type);
            resourcePath(model.resourcePath);
            failureThreshold(model.failureThreshold);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResourcePath() {
            return resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }
    }
}
