/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about an instance that Amazon Route 53 creates when you submit a
 * <code>RegisterInstance</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements StructuredPojo, ToCopyableBuilder<Instance.Builder, Instance> {
    private final String id;

    private final String creatorRequestId;

    private final Map<String, String> attributes;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorRequestId = builder.creatorRequestId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * An identifier that you want to associate with the instance. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can use this value to update an existing instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * To associate a new instance, you must specify a value that is unique among instances that you associate by using
     * the same service.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An identifier that you want to associate with the instance. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can use this value to update an existing instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To associate a new instance, you must specify a value that is unique among instances that you associate
     *         by using the same service.
     *         </p>
     *         </li>
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
     * helps to determine if a specific client owns the namespace.
     * </p>
     * 
     * @return An optional parameter that you can use to resolve concurrent creation requests.
     *         <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A string map that contains attribute keys and values. Supported attribute keys include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health checks
     * on. This value is also used for the port value in an SRV record if the service that you specify includes an SRV
     * record. For more information, see <a>CreateService</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_IP</code>: If the service that you specify contains a resource record set template for an A or
     * AAAA record, the IP address that you want Amazon Route 53 to use for the value of the A record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_WEIGHT</code>: The weight value in an SRV record if the service that you specify includes an
     * SRV record. You can also specify a default weight that is applied to all instances in the <code>Service</code>
     * configuration. For more information, see <a>CreateService</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_PRIORITY</code>: The priority value in an SRV record if the service that you specify includes
     * an SRV record.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string map that contains attribute keys and values. Supported attribute keys include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health
     *         checks on. This value is also used for the port value in an SRV record if the service that you specify
     *         includes an SRV record. For more information, see <a>CreateService</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_IP</code>: If the service that you specify contains a resource record set template for
     *         an A or AAAA record, the IP address that you want Amazon Route 53 to use for the value of the A record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_WEIGHT</code>: The weight value in an SRV record if the service that you specify
     *         includes an SRV record. You can also specify a default weight that is applied to all instances in the
     *         <code>Service</code> configuration. For more information, see <a>CreateService</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_PRIORITY</code>: The priority value in an SRV record if the service that you specify
     *         includes an SRV record.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("Instance").add("Id", id()).add("CreatorRequestId", creatorRequestId())
                .add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * An identifier that you want to associate with the instance. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can use this value to update an existing instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * To associate a new instance, you must specify a value that is unique among instances that you associate by
         * using the same service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param id
         *        An identifier that you want to associate with the instance. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can use this value to update an existing instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To associate a new instance, you must specify a value that is unique among instances that you
         *        associate by using the same service.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
         * helps to determine if a specific client owns the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        An optional parameter that you can use to resolve concurrent creation requests.
         *        <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A string map that contains attribute keys and values. Supported attribute keys include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health
         * checks on. This value is also used for the port value in an SRV record if the service that you specify
         * includes an SRV record. For more information, see <a>CreateService</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_IP</code>: If the service that you specify contains a resource record set template for an
         * A or AAAA record, the IP address that you want Amazon Route 53 to use for the value of the A record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_WEIGHT</code>: The weight value in an SRV record if the service that you specify includes
         * an SRV record. You can also specify a default weight that is applied to all instances in the
         * <code>Service</code> configuration. For more information, see <a>CreateService</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_PRIORITY</code>: The priority value in an SRV record if the service that you specify
         * includes an SRV record.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A string map that contains attribute keys and values. Supported attribute keys include the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform
         *        health checks on. This value is also used for the port value in an SRV record if the service that you
         *        specify includes an SRV record. For more information, see <a>CreateService</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_IP</code>: If the service that you specify contains a resource record set template
         *        for an A or AAAA record, the IP address that you want Amazon Route 53 to use for the value of the A
         *        record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_WEIGHT</code>: The weight value in an SRV record if the service that you specify
         *        includes an SRV record. You can also specify a default weight that is applied to all instances in the
         *        <code>Service</code> configuration. For more information, see <a>CreateService</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_PRIORITY</code>: The priority value in an SRV record if the service that you
         *        specify includes an SRV record.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String creatorRequestId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            id(model.id);
            creatorRequestId(model.creatorRequestId);
            attributes(model.attributes);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
