/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<ListInstancesRequest.Builder, ListInstancesRequest> {
    private final String serviceId;

    private final String nextToken;

    private final Integer maxResults;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the service that you want to list instances for.
     * </p>
     * 
     * @return The ID of the service that you want to list instances for.
     */
    public String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * For the first <code>ListInstances</code> request, omit this value.
     * </p>
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return For the first <code>ListInstances</code> request, omit this value.</p>
     *         <p>
     *         If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>ListInstances</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of instances that you want Amazon Route 53 to return in the response to a
     * <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53
     * returns up to 100 instances.
     * </p>
     * 
     * @return The maximum number of instances that you want Amazon Route 53 to return in the response to a
     *         <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon
     *         Route 53 returns up to 100 instances.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("ListInstancesRequest").add("ServiceId", serviceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, CopyableBuilder<Builder, ListInstancesRequest> {
        /**
         * <p>
         * The ID of the service that you want to list instances for.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service that you want to list instances for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * For the first <code>ListInstances</code> request, omit this value.
         * </p>
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>ListInstances</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        For the first <code>ListInstances</code> request, omit this value.</p>
         *        <p>
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>ListInstances</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of instances that you want Amazon Route 53 to return in the response to a
         * <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon Route 53
         * returns up to 100 instances.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of instances that you want Amazon Route 53 to return in the response to a
         *        <code>ListInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Amazon
         *        Route 53 returns up to 100 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String serviceId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            serviceId(model.serviceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }
    }
}
