/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListOperationsResponse.Builder, ListOperationsResponse> {
    private final List<OperationSummary> operations;

    private final String nextToken;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Summary information about the operations that match the specified criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Summary information about the operations that match the specified criteria.
     */
    public List<OperationSummary> operations() {
        return operations;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> operations match the specified criteria, you can submit another
     * <code>ListOperations</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> operations match the specified criteria, you can submit another
     *         <code>ListOperations</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse) obj;
        return Objects.equals(operations(), other.operations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOperationsResponse").add("Operations", operations()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, ListOperationsResponse> {
        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * 
         * @param operations
         *        Summary information about the operations that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<OperationSummary> operations);

        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * 
         * @param operations
         *        Summary information about the operations that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(OperationSummary... operations);

        /**
         * <p>
         * Summary information about the operations that match the specified criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OperationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<OperationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperationSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #operations(List<OperationSummary>)}.
         * 
         * @param operations
         *        a consumer that will call methods on {@link List<OperationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(List<OperationSummary>)
         */
        Builder operations(Consumer<OperationSummary.Builder>... operations);

        /**
         * <p>
         * If more than <code>MaxResults</code> operations match the specified criteria, you can submit another
         * <code>ListOperations</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> operations match the specified criteria, you can submit another
         *        <code>ListOperations</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<OperationSummary> operations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            operations(model.operations);
            nextToken(model.nextToken);
        }

        public final Collection<OperationSummary.Builder> getOperations() {
            return operations != null ? operations.stream().map(OperationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<OperationSummary.Builder>... operations) {
            operations(Stream.of(operations).map(c -> OperationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }
    }
}
