/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListServicesResponse.Builder, ListServicesResponse> {
    private final List<ServiceSummary> services;

    private final String nextToken;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
     *         filter criteria.
     */
    public List<ServiceSummary> services() {
        return services;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> operations match the specified criteria, the value of <code>NextToken</code>
     * is the first service in the next group of services that were created by the current AWS account. To get the next
     * group, specify the value of <code>NextToken</code> from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> operations match the specified criteria, the value of
     *         <code>NextToken</code> is the first service in the next group of services that were created by the
     *         current AWS account. To get the next group, specify the value of <code>NextToken</code> from the previous
     *         response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(services());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse) obj;
        return Objects.equals(services(), other.services()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListServicesResponse").add("Services", services()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, ListServicesResponse> {
        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param services
         *        An array that contains one <code>ServiceSummary</code> object for each service that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<ServiceSummary> services);

        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param services
         *        An array that contains one <code>ServiceSummary</code> object for each service that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(ServiceSummary... services);

        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #services(List<ServiceSummary>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<ServiceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<ServiceSummary>)
         */
        Builder services(Consumer<ServiceSummary.Builder>... services);

        /**
         * <p>
         * If more than <code>MaxResults</code> operations match the specified criteria, the value of
         * <code>NextToken</code> is the first service in the next group of services that were created by the current
         * AWS account. To get the next group, specify the value of <code>NextToken</code> from the previous response in
         * the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> operations match the specified criteria, the value of
         *        <code>NextToken</code> is the first service in the next group of services that were created by the
         *        current AWS account. To get the next group, specify the value of <code>NextToken</code> from the
         *        previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<ServiceSummary> services = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            services(model.services);
            nextToken(model.nextToken);
        }

        public final Collection<ServiceSummary.Builder> getServices() {
            return services != null ? services.stream().map(ServiceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ServiceSummary> services) {
            this.services = ServiceSummariesListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceSummary... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceSummary.Builder>... services) {
            services(Stream.of(services).map(c -> ServiceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ServiceSummary.BuilderImpl> services) {
            this.services = ServiceSummariesListCopier.copyFromBuilder(services);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }
    }
}
