/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.NamespaceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Namespace implements StructuredPojo, ToCopyableBuilder<Namespace.Builder, Namespace> {
    private final String id;

    private final String arn;

    private final String name;

    private final String type;

    private final String description;

    private final Integer serviceCount;

    private final NamespaceProperties properties;

    private final Instant createDate;

    private final String creatorRequestId;

    private Namespace(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.serviceCount = builder.serviceCount;
        this.properties = builder.properties;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The ID of a namespace.
     * </p>
     * 
     * @return The ID of a namespace.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace when you create it.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the namespace, such as <code>example.com</code>.
     * </p>
     * 
     * @return The name of the namespace, such as <code>example.com</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
     * @see NamespaceType
     */
    public NamespaceType type() {
        return NamespaceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
     * @see NamespaceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description that you specify for the namespace when you create it.
     * </p>
     * 
     * @return The description that you specify for the namespace when you create it.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The number of services that are associated with the namespace.
     * </p>
     * 
     * @return The number of services that are associated with the namespace.
     */
    public Integer serviceCount() {
        return serviceCount;
    }

    /**
     * <p>
     * A complex type that contains information that's specific to the type of the namespace.
     * </p>
     * 
     * @return A complex type that contains information that's specific to the type of the namespace.
     */
    public NamespaceProperties properties() {
        return properties;
    }

    /**
     * <p>
     * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC).
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
     * helps to determine if a specific client owns the namespace.
     * </p>
     * 
     * @return An optional parameter that you can use to resolve concurrent creation requests.
     *         <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(serviceCount(), other.serviceCount()) && Objects.equals(properties(), other.properties())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    @Override
    public String toString() {
        return ToString.builder("Namespace").add("Id", id()).add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Description", description()).add("ServiceCount", serviceCount()).add("Properties", properties())
                .add("CreateDate", createDate()).add("CreatorRequestId", creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ServiceCount":
            return Optional.ofNullable(clazz.cast(serviceCount()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NamespaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Namespace> {
        /**
         * <p>
         * The ID of a namespace.
         * </p>
         * 
         * @param id
         *        The ID of a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the namespace when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the namespace, such as <code>example.com</code>.
         * </p>
         * 
         * @param name
         *        The name of the namespace, such as <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
         * </p>
         * 
         * @param type
         *        The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
         * @see NamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
         * </p>
         * 
         * @param type
         *        The type of the namespace. Valid values are <code>DNS_PUBLIC</code> and <code>DNS_PRIVATE</code>.
         * @see NamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceType
         */
        Builder type(NamespaceType type);

        /**
         * <p>
         * The description that you specify for the namespace when you create it.
         * </p>
         * 
         * @param description
         *        The description that you specify for the namespace when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of services that are associated with the namespace.
         * </p>
         * 
         * @param serviceCount
         *        The number of services that are associated with the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCount(Integer serviceCount);

        /**
         * <p>
         * A complex type that contains information that's specific to the type of the namespace.
         * </p>
         * 
         * @param properties
         *        A complex type that contains information that's specific to the type of the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(NamespaceProperties properties);

        /**
         * <p>
         * A complex type that contains information that's specific to the type of the namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link NamespaceProperties.Builder} avoiding the need
         * to create one manually via {@link NamespaceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link NamespaceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #properties(NamespaceProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link NamespaceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(NamespaceProperties)
         */
        default Builder properties(Consumer<NamespaceProperties.Builder> properties) {
            return properties(NamespaceProperties.builder().applyMutation(properties).build());
        }

        /**
         * <p>
         * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param createDate
         *        The date that the namespace was created, in Unix date/time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
         * helps to determine if a specific client owns the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        An optional parameter that you can use to resolve concurrent creation requests.
         *        <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String type;

        private String description;

        private Integer serviceCount;

        private NamespaceProperties properties;

        private Instant createDate;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Namespace model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            type(model.type);
            description(model.description);
            serviceCount(model.serviceCount);
            properties(model.properties);
            createDate(model.createDate);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NamespaceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getServiceCount() {
            return serviceCount;
        }

        @Override
        public final Builder serviceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public final void setServiceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        public final NamespaceProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        @Override
        public final Builder properties(NamespaceProperties properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(NamespaceProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public Namespace build() {
            return new Namespace(this);
        }
    }
}
