/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service can't be created because a service with the same name already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAlreadyExistsException extends ServiceDiscoveryException implements
        ToCopyableBuilder<ServiceAlreadyExistsException.Builder, ServiceAlreadyExistsException> {
    private final String creatorRequestId;

    private final String serviceId;

    private ServiceAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.serviceId = builder.serviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The <code>CreatorRequestId</code> that was used to create the service.
     * </p>
     * 
     * @return The <code>CreatorRequestId</code> that was used to create the service.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the existing service.
     * </p>
     * 
     * @return The ID of the existing service.
     */
    public String serviceId() {
        return serviceId;
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceAlreadyExistsException>, ServiceDiscoveryException.Builder {
        /**
         * <p>
         * The <code>CreatorRequestId</code> that was used to create the service.
         * </p>
         * 
         * @param creatorRequestId
         *        The <code>CreatorRequestId</code> that was used to create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the existing service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the existing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ServiceDiscoveryException.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String serviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAlreadyExistsException model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            serviceId(model.serviceId);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @JsonProperty("CreatorRequestId")
        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @JsonProperty("ServiceId")
        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceAlreadyExistsException build() {
            return new ServiceAlreadyExistsException(this);
        }
    }
}
