/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceChangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains changes to an existing service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceChange implements StructuredPojo, ToCopyableBuilder<ServiceChange.Builder, ServiceChange> {
    private final String description;

    private final DnsConfigChange dnsConfig;

    private final HealthCheckConfig healthCheckConfig;

    private ServiceChange(BuilderImpl builder) {
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    /**
     * <p>
     * A description for the service.
     * </p>
     * 
     * @return A description for the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A complex type that contains information about the resource record sets that you want Amazon Route 53 to create
     * when you register an instance.
     * </p>
     * 
     * @return A complex type that contains information about the resource record sets that you want Amazon Route 53 to
     *         create when you register an instance.
     */
    public DnsConfigChange dnsConfig() {
        return dnsConfig;
    }

    /**
     * Returns the value of the HealthCheckConfig property for this object.
     * 
     * @return The value of the HealthCheckConfig property for this object.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceChange)) {
            return false;
        }
        ServiceChange other = (ServiceChange) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("ServiceChange").add("Description", description()).add("DnsConfig", dnsConfig())
                .add("HealthCheckConfig", healthCheckConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DnsConfig":
            return Optional.ofNullable(clazz.cast(dnsConfig()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceChange> {
        /**
         * <p>
         * A description for the service.
         * </p>
         * 
         * @param description
         *        A description for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A complex type that contains information about the resource record sets that you want Amazon Route 53 to
         * create when you register an instance.
         * </p>
         * 
         * @param dnsConfig
         *        A complex type that contains information about the resource record sets that you want Amazon Route 53
         *        to create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfigChange dnsConfig);

        /**
         * <p>
         * A complex type that contains information about the resource record sets that you want Amazon Route 53 to
         * create when you register an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsConfigChange.Builder} avoiding the need to
         * create one manually via {@link DnsConfigChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfigChange.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsConfig(DnsConfigChange)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfigChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfigChange)
         */
        default Builder dnsConfig(Consumer<DnsConfigChange.Builder> dnsConfig) {
            return dnsConfig(DnsConfigChange.builder().applyMutation(dnsConfig).build());
        }

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * @param healthCheckConfig
         *        The new value for the HealthCheckConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private DnsConfigChange dnsConfig;

        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceChange model) {
            description(model.description);
            dnsConfig(model.dnsConfig);
            healthCheckConfig(model.healthCheckConfig);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfigChange.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfigChange dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfigChange.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public ServiceChange build() {
            return new ServiceChange(this);
        }
    }
}
