/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.RecordType;
import software.amazon.awssdk.services.servicediscovery.transform.DnsRecordMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, DnsRecord> {
    private final String type;
    private final Long ttl;

    private DnsRecord(BuilderImpl builder) {
        this.type = builder.type;
        this.ttl = builder.ttl;
    }

    public RecordType type() {
        return RecordType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Long ttl() {
        return this.ttl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord other = (DnsRecord)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ttl(), other.ttl());
    }

    public String toString() {
        return ToString.builder((String)"DnsRecord").add("Type", (Object)this.typeAsString()).add("TTL", (Object)this.ttl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Long ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRecord model) {
            this.type(model.type);
            this.ttl(model.ttl);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecordType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public DnsRecord build() {
            return new DnsRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DnsRecord> {
        public Builder type(String var1);

        public Builder type(RecordType var1);

        public Builder ttl(Long var1);
    }
}

