/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckType;
import software.amazon.awssdk.services.servicediscovery.transform.HealthCheckConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheckConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, HealthCheckConfig> {
    private final String type;
    private final String resourcePath;
    private final Integer failureThreshold;

    private HealthCheckConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.failureThreshold = builder.failureThreshold;
    }

    public HealthCheckType type() {
        return HealthCheckType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resourcePath(), other.resourcePath()) && Objects.equals(this.failureThreshold(), other.failureThreshold());
    }

    public String toString() {
        return ToString.builder((String)"HealthCheckConfig").add("Type", (Object)this.typeAsString()).add("ResourcePath", (Object)this.resourcePath()).add("FailureThreshold", (Object)this.failureThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ResourcePath": {
                return Optional.ofNullable(clazz.cast(this.resourcePath()));
            }
            case "FailureThreshold": {
                return Optional.ofNullable(clazz.cast(this.failureThreshold()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HealthCheckConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String resourcePath;
        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            this.type(model.type);
            this.resourcePath(model.resourcePath);
            this.failureThreshold(model.failureThreshold);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public final Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheckConfig> {
        public Builder type(String var1);

        public Builder type(HealthCheckType var1);

        public Builder resourcePath(String var1);

        public Builder failureThreshold(Integer var1);
    }
}

