/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.FilterCondition;
import software.amazon.awssdk.services.servicediscovery.model.FilterValuesCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceFilterName;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, ServiceFilter> {
    private final String name;
    private final List<String> values;
    private final String condition;

    private ServiceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    public ServiceFilterName name() {
        return ServiceFilterName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public List<String> values() {
        return this.values;
    }

    public FilterCondition condition() {
        return FilterCondition.fromValue(this.condition);
    }

    public String conditionAsString() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceFilter)) {
            return false;
        }
        ServiceFilter other = (ServiceFilter)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.conditionAsString(), other.conditionAsString());
    }

    public String toString() {
        return ToString.builder((String)"ServiceFilter").add("Name", (Object)this.nameAsString()).add("Values", this.values()).add("Condition", (Object)this.conditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.conditionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceFilter model) {
            this.name(model.name);
            this.values(model.values);
            this.condition(model.condition);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ServiceFilterName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getCondition() {
            return this.condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        public ServiceFilter build() {
            return new ServiceFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceFilter> {
        public Builder name(String var1);

        public Builder name(ServiceFilterName var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder condition(String var1);

        public Builder condition(FilterCondition var1);
    }
}

