/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.DnsProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DnsPropertiesMarshaller {
    private static final MarshallingInfo<String> HOSTEDZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostedZoneId").isBinary(false).build();
    private static final DnsPropertiesMarshaller INSTANCE = new DnsPropertiesMarshaller();

    private DnsPropertiesMarshaller() {
    }

    public static DnsPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DnsProperties dnsProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dnsProperties, (String)"dnsProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dnsProperties.hostedZoneId(), HOSTEDZONEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

