/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.ServiceFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceFilterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Condition").isBinary(false).build();
    private static final ServiceFilterMarshaller INSTANCE = new ServiceFilterMarshaller();

    private ServiceFilterMarshaller() {
    }

    public static ServiceFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceFilter serviceFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceFilter, (String)"serviceFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceFilter.nameAsString(), NAME_BINDING);
            protocolMarshaller.marshall(serviceFilter.values(), VALUES_BINDING);
            protocolMarshaller.marshall((Object)serviceFilter.conditionAsString(), CONDITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

