/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSummary implements StructuredPojo, ToCopyableBuilder<ServiceSummary.Builder, ServiceSummary> {
    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final Integer instanceCount;

    private ServiceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * The ID that Route 53 assigned to the service when you created it.
     * </p>
     * 
     * @return The ID that Route 53 assigned to the service when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Route 53 assigns to the service when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Route 53 assigns to the service when you create it.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description that you specify when you create the service.
     * </p>
     * 
     * @return The description that you specify when you create the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The number of instances that are currently associated with the service. Instances that were previously associated
     * with the service but that have been deleted are not included in the count.
     * </p>
     * 
     * @return The number of instances that are currently associated with the service. Instances that were previously
     *         associated with the service but that have been deleted are not included in the count.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(instanceCount(), other.instanceCount());
    }

    @Override
    public String toString() {
        return ToString.builder("ServiceSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("InstanceCount", instanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceSummary> {
        /**
         * <p>
         * The ID that Route 53 assigned to the service when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Route 53 assigned to the service when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Route 53 assigns to the service when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that Route 53 assigns to the service when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description that you specify when you create the service.
         * </p>
         * 
         * @param description
         *        The description that you specify when you create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of instances that are currently associated with the service. Instances that were previously
         * associated with the service but that have been deleted are not included in the count.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are currently associated with the service. Instances that were previously
         *        associated with the service but that have been deleted are not included in the count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            instanceCount(model.instanceCount);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public ServiceSummary build() {
            return new ServiceSummary(this);
        }
    }
}
