/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePrivateDnsNamespaceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<CreatePrivateDnsNamespaceRequest.Builder, CreatePrivateDnsNamespaceRequest> {
    private final String name;

    private final String creatorRequestId;

    private final String description;

    private final String vpc;

    private CreatePrivateDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53 automatically
     * creates a hosted zone that has the same name as the namespace.
     * </p>
     * 
     * @return The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
     *         automatically creates a hosted zone that has the same name as the namespace.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
     * helps to determine if a specific client owns the namespace.
     * </p>
     * 
     * @return An optional parameter that you can use to resolve concurrent creation requests.
     *         <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A description for the namespace.
     * </p>
     * 
     * @return A description for the namespace.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon VPC that you want to associate the namespace with.
     * </p>
     * 
     * @return The ID of the Amazon VPC that you want to associate the namespace with.
     */
    public String vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateDnsNamespaceRequest)) {
            return false;
        }
        CreatePrivateDnsNamespaceRequest other = (CreatePrivateDnsNamespaceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(description(), other.description()) && Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePrivateDnsNamespaceRequest").add("Name", name())
                .add("CreatorRequestId", creatorRequestId()).add("Description", description()).add("Vpc", vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "CreatorRequestId":
            return Optional.of(clazz.cast(creatorRequestId()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Vpc":
            return Optional.of(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, CopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
        /**
         * <p>
         * The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
         * automatically creates a hosted zone that has the same name as the namespace.
         * </p>
         * 
         * @param name
         *        The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
         *        automatically creates a hosted zone that has the same name as the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
         * helps to determine if a specific client owns the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        An optional parameter that you can use to resolve concurrent creation requests.
         *        <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A description for the namespace.
         * </p>
         * 
         * @param description
         *        A description for the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon VPC that you want to associate the namespace with.
         * </p>
         * 
         * @param vpc
         *        The ID of the Amazon VPC that you want to associate the namespace with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String name;

        private String creatorRequestId;

        private String description;

        private String vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateDnsNamespaceRequest model) {
            name(model.name);
            creatorRequestId(model.creatorRequestId);
            description(model.description);
            vpc(model.vpc);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpc() {
            return vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateDnsNamespaceRequest build() {
            return new CreatePrivateDnsNamespaceRequest(this);
        }
    }
}
