/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListNamespacesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListNamespacesResponse.Builder, ListNamespacesResponse> {
    private final List<NamespaceSummary> namespaces;

    private final String nextToken;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
     * filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
     *         specified filter criteria.
     */
    public List<NamespaceSummary> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> namespaces match the specified criteria, you can submit another
     * <code>ListNamespaces</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> namespaces match the specified criteria, you can submit another
     *         <code>ListNamespaces</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespaces());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse) obj;
        return Objects.equals(namespaces(), other.namespaces()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListNamespacesResponse").add("Namespaces", namespaces()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespaces":
            return Optional.of(clazz.cast(namespaces()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, ListNamespacesResponse> {
        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<NamespaceSummary> namespaces);

        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(NamespaceSummary... namespaces);

        /**
         * <p>
         * If more than <code>MaxResults</code> namespaces match the specified criteria, you can submit another
         * <code>ListNamespaces</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> namespaces match the specified criteria, you can submit another
         *        <code>ListNamespaces</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<NamespaceSummary> namespaces;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            namespaces(model.namespaces);
            nextToken(model.nextToken);
        }

        public final Collection<NamespaceSummary.Builder> getNamespaces() {
            return namespaces != null ? namespaces.stream().map(NamespaceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder namespaces(Collection<NamespaceSummary> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceSummary... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final void setNamespaces(Collection<NamespaceSummary.BuilderImpl> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copyFromBuilder(namespaces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }
    }
}
