/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.OperationFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lets you select the operations that you want to list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationFilter implements StructuredPojo, ToCopyableBuilder<OperationFilter.Builder, OperationFilter> {
    private final String name;

    private final List<String> values;

    private final String condition;

    private OperationFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * Specify the operations that you want to get:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Gets operations related to specified services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Gets specified types of operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OperationFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Specify the operations that you want to get:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Gets operations related to specified services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     *         <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Gets specified types of operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     *         </p>
     *         </li>
     * @see OperationFilterName
     */
    public OperationFilterName name() {
        return OperationFilterName.fromValue(name);
    }

    /**
     * <p>
     * Specify the operations that you want to get:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Gets operations related to specified services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Gets specified types of operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OperationFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameString}.
     * </p>
     * 
     * @return Specify the operations that you want to get:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Gets operations related to specified services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     *         <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Gets specified types of operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     *         </p>
     *         </li>
     * @see OperationFilterName
     */
    public String nameString() {
        return name;
    }

    /**
     * <p>
     * Specify values that are applicable to the value that you specify for <code>Name</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Specify one namespace ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Specify one service ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>,
     * or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
     * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
     * <code>DEREGISTER_INSTANCE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time
     * (UTC). The start date must be the first value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Specify one namespace ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Specify one service ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
     *         <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
     *         <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
     *         <code>DEREGISTER_INSTANCE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
     *         Universal Time (UTC). The start date must be the first value.
     *         </p>
     *         </li>
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator that you want to use to determine whether an operation matches the specified value. Valid values for
     * condition include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
     * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
     * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one
     * of the specified values to be returned in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first value.
     * <code>BETWEEN</code> is supported for <code>U</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether an operation matches the specified value. Valid
     *         values for condition include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     *         <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>,
     *         and <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
     *         more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
     *         must match one of the specified values to be returned in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first
     *         value. <code>BETWEEN</code> is supported for <code>U</code>.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public FilterCondition condition() {
        return FilterCondition.fromValue(condition);
    }

    /**
     * <p>
     * The operator that you want to use to determine whether an operation matches the specified value. Valid values for
     * condition include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
     * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
     * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one
     * of the specified values to be returned in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first value.
     * <code>BETWEEN</code> is supported for <code>U</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether an operation matches the specified value. Valid
     *         values for condition include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     *         <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>,
     *         and <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
     *         more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
     *         must match one of the specified values to be returned in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first
     *         value. <code>BETWEEN</code> is supported for <code>U</code>.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public String conditionString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(conditionString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationFilter)) {
            return false;
        }
        OperationFilter other = (OperationFilter) obj;
        return Objects.equals(nameString(), other.nameString()) && Objects.equals(values(), other.values())
                && Objects.equals(conditionString(), other.conditionString());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationFilter").add("Name", nameString()).add("Values", values())
                .add("Condition", conditionString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(nameString()));
        case "Values":
            return Optional.of(clazz.cast(values()));
        case "Condition":
            return Optional.of(clazz.cast(conditionString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, OperationFilter> {
        /**
         * <p>
         * Specify the operations that you want to get:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Gets operations related to specified services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Gets specified types of operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specify the operations that you want to get:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Gets operations related to specified services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         *        <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Gets specified types of operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         *        </p>
         *        </li>
         * @see OperationFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * Specify the operations that you want to get:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Gets operations related to specified services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Gets specified types of operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specify the operations that you want to get:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Gets operations related to specified services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         *        <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Gets specified types of operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         *        </p>
         *        </li>
         * @see OperationFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationFilterName
         */
        Builder name(OperationFilterName name);

        /**
         * <p>
         * Specify values that are applicable to the value that you specify for <code>Name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Specify one namespace ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Specify one service ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         * <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         * <code>DEREGISTER_INSTANCE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Specify one namespace ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Specify one service ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         *        <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         *        <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         *        <code>DEREGISTER_INSTANCE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * Specify values that are applicable to the value that you specify for <code>Name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Specify one namespace ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Specify one service ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         * <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         * <code>DEREGISTER_INSTANCE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Specify one namespace ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Specify one service ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         *        <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         *        <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         *        <code>DEREGISTER_INSTANCE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator that you want to use to determine whether an operation matches the specified value. Valid values
         * for condition include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
         * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
         * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match
         * one of the specified values to be returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first
         * value. <code>BETWEEN</code> is supported for <code>U</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether an operation matches the specified value. Valid
         *        values for condition include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         *        <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>,
         *        <code>STATUS</code>, and <code>TYPE</code>. <code>EQ</code> is the default condition and can be
         *        omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
         *        more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
         *        must match one of the specified values to be returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the
         *        first value. <code>BETWEEN</code> is supported for <code>U</code>.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The operator that you want to use to determine whether an operation matches the specified value. Valid values
         * for condition include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
         * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
         * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match
         * one of the specified values to be returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the first
         * value. <code>BETWEEN</code> is supported for <code>U</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether an operation matches the specified value. Valid
         *        values for condition include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         *        <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>,
         *        <code>STATUS</code>, and <code>TYPE</code>. <code>EQ</code> is the default condition and can be
         *        omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
         *        more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
         *        must match one of the specified values to be returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Specify two values, a start date and an end date. The start date must be the
         *        first value. <code>BETWEEN</code> is supported for <code>U</code>.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(FilterCondition condition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationFilter model) {
            name(model.name);
            values(model.values);
            condition(model.condition);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OperationFilterName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getCondition() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public OperationFilter build() {
            return new OperationFilter(this);
        }
    }
}
