/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterInstanceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<RegisterInstanceRequest.Builder, RegisterInstanceRequest> {
    private final String serviceId;

    private final String instanceId;

    private final String creatorRequestId;

    private final Map<String, String> attributes;

    private RegisterInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.instanceId = builder.instanceId;
        this.creatorRequestId = builder.creatorRequestId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The ID of the service that you want to use for settings for the resource record sets and health check that Amazon
     * Route 53 will create.
     * </p>
     * 
     * @return The ID of the service that you want to use for settings for the resource record sets and health check
     *         that Amazon Route 53 will create.
     */
    public String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * An identifier that you want to associate with the instance. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can use this value to update an existing instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * To register a new instance, you must specify a value that is unique among instances that you register by using
     * the same service.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An identifier that you want to associate with the instance. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can use this value to update an existing instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To register a new instance, you must specify a value that is unique among instances that you register by
     *         using the same service.
     *         </p>
     *         </li>
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
     * helps to determine if a specific client owns the namespace.
     * </p>
     * 
     * @return An optional parameter that you can use to resolve concurrent creation requests.
     *         <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A string map that contain attribute keys and values. Supported attribute keys include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health checks
     * on. This value is also used for the port value in an SRV record if the service that you specify includes an SRV
     * record. For more information, see <a>CreateService</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_IPV4</code>: If the service that you specify contains a resource record set template for an A
     * record, the IPv4 address that you want Amazon Route 53 to use for the value of the A record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_IPV6</code>: If the service that you specify contains a resource record set template for an
     * AAAA record, the IPv6 address that you want Amazon Route 53 to use for the value of the AAAA record.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string map that contain attribute keys and values. Supported attribute keys include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health
     *         checks on. This value is also used for the port value in an SRV record if the service that you specify
     *         includes an SRV record. For more information, see <a>CreateService</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_IPV4</code>: If the service that you specify contains a resource record set template
     *         for an A record, the IPv4 address that you want Amazon Route 53 to use for the value of the A record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_IPV6</code>: If the service that you specify contains a resource record set template
     *         for an AAAA record, the IPv6 address that you want Amazon Route 53 to use for the value of the AAAA
     *         record.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterInstanceRequest").add("ServiceId", serviceId()).add("InstanceId", instanceId())
                .add("CreatorRequestId", creatorRequestId()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.of(clazz.cast(serviceId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "CreatorRequestId":
            return Optional.of(clazz.cast(creatorRequestId()));
        case "Attributes":
            return Optional.of(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, CopyableBuilder<Builder, RegisterInstanceRequest> {
        /**
         * <p>
         * The ID of the service that you want to use for settings for the resource record sets and health check that
         * Amazon Route 53 will create.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service that you want to use for settings for the resource record sets and health check
         *        that Amazon Route 53 will create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * An identifier that you want to associate with the instance. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can use this value to update an existing instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * To register a new instance, you must specify a value that is unique among instances that you register by
         * using the same service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceId
         *        An identifier that you want to associate with the instance. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can use this value to update an existing instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To register a new instance, you must specify a value that is unique among instances that you register
         *        by using the same service.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
         * helps to determine if a specific client owns the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        An optional parameter that you can use to resolve concurrent creation requests.
         *        <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A string map that contain attribute keys and values. Supported attribute keys include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform health
         * checks on. This value is also used for the port value in an SRV record if the service that you specify
         * includes an SRV record. For more information, see <a>CreateService</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_IPV4</code>: If the service that you specify contains a resource record set template for
         * an A record, the IPv4 address that you want Amazon Route 53 to use for the value of the A record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_IPV6</code>: If the service that you specify contains a resource record set template for
         * an AAAA record, the IPv6 address that you want Amazon Route 53 to use for the value of the AAAA record.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A string map that contain attribute keys and values. Supported attribute keys include the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_PORT</code>: The port on the endpoint that you want Amazon Route 53 to perform
         *        health checks on. This value is also used for the port value in an SRV record if the service that you
         *        specify includes an SRV record. For more information, see <a>CreateService</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_IPV4</code>: If the service that you specify contains a resource record set
         *        template for an A record, the IPv4 address that you want Amazon Route 53 to use for the value of the A
         *        record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_IPV6</code>: If the service that you specify contains a resource record set
         *        template for an AAAA record, the IPv6 address that you want Amazon Route 53 to use for the value of
         *        the AAAA record.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String serviceId;

        private String instanceId;

        private String creatorRequestId;

        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            serviceId(model.serviceId);
            instanceId(model.instanceId);
            creatorRequestId(model.creatorRequestId);
            attributes(model.attributes);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }
    }
}
