/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the specified service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Service implements StructuredPojo, ToCopyableBuilder<Service.Builder, Service> {
    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final Integer instanceCount;

    private final DnsConfig dnsConfig;

    private final HealthCheckConfig healthCheckConfig;

    private final Instant createDate;

    private final String creatorRequestId;

    private Service(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.instanceCount = builder.instanceCount;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the service when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the service when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service when you create it.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the service.
     * </p>
     * 
     * @return The description of the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The number of instances that are currently associated with the service. Instances that were previously associated
     * with the service but that have been deleted are not included in the count.
     * </p>
     * 
     * @return The number of instances that are currently associated with the service. Instances that were previously
     *         associated with the service but that have been deleted are not included in the count.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * A complex type that contains information about the resource record sets that you want Amazon Route 53 to create
     * when you register an instance.
     * </p>
     * 
     * @return A complex type that contains information about the resource record sets that you want Amazon Route 53 to
     *         create when you register an instance.
     */
    public DnsConfig dnsConfig() {
        return dnsConfig;
    }

    /**
     * <p>
     * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If you
     * specify settings for a health check, Amazon Route 53 associates the health check with all the resource record
     * sets that you specify in <code>DnsConfig</code>.
     * </p>
     * <note>
     * <p>
     * The health check uses 30 seconds as the request interval. This is the number of seconds between the time that
     * each Amazon Route 53 health checker gets a response from your endpoint and the time that it sends the next health
     * check request. A health checker in each data center around the world sends your endpoint a health check request
     * every 30 seconds. On average, your endpoint receives a health check request about every two seconds. Health
     * checkers in different data centers don't coordinate with one another, so you'll sometimes see several requests
     * per second followed by a few seconds with no health checks at all.
     * </p>
     * </note>
     * <p>
     * For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * 
     * @return <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If
     *         you specify settings for a health check, Amazon Route 53 associates the health check with all the
     *         resource record sets that you specify in <code>DnsConfig</code>.</p> <note>
     *         <p>
     *         The health check uses 30 seconds as the request interval. This is the number of seconds between the time
     *         that each Amazon Route 53 health checker gets a response from your endpoint and the time that it sends
     *         the next health check request. A health checker in each data center around the world sends your endpoint
     *         a health check request every 30 seconds. On average, your endpoint receives a health check request about
     *         every two seconds. Health checkers in different data centers don't coordinate with one another, so you'll
     *         sometimes see several requests per second followed by a few seconds with no health checks at all.
     *         </p>
     *         </note>
     *         <p>
     *         For information about the charges for health checks, see <a
     *         href="http://aws.amazon.com/route53/pricing">Amazon Route 53 Pricing</a>.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC).
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
     * helps to determine if a specific client owns the namespace.
     * </p>
     * 
     * @return An optional parameter that you can use to resolve concurrent creation requests.
     *         <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    @Override
    public String toString() {
        return ToString.builder("Service").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("InstanceCount", instanceCount()).add("DnsConfig", dnsConfig())
                .add("HealthCheckConfig", healthCheckConfig()).add("CreateDate", createDate())
                .add("CreatorRequestId", creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "DnsConfig":
            return Optional.of(clazz.cast(dnsConfig()));
        case "HealthCheckConfig":
            return Optional.of(clazz.cast(healthCheckConfig()));
        case "CreateDate":
            return Optional.of(clazz.cast(createDate()));
        case "CreatorRequestId":
            return Optional.of(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the service when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the service when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that Amazon Route 53 assigns to the service when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the service.
         * </p>
         * 
         * @param description
         *        The description of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of instances that are currently associated with the service. Instances that were previously
         * associated with the service but that have been deleted are not included in the count.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are currently associated with the service. Instances that were previously
         *        associated with the service but that have been deleted are not included in the count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A complex type that contains information about the resource record sets that you want Amazon Route 53 to
         * create when you register an instance.
         * </p>
         * 
         * @param dnsConfig
         *        A complex type that contains information about the resource record sets that you want Amazon Route 53
         *        to create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfig dnsConfig);

        /**
         * <p>
         * A complex type that contains information about the resource record sets that you want Amazon Route 53 to
         * create when you register an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsConfig.Builder} avoiding the need to create
         * one manually via {@link DnsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsConfig(DnsConfig)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfig)
         */
        default Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return dnsConfig(DnsConfig.builder().apply(dnsConfig).build());
        }

        /**
         * <p>
         * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If you
         * specify settings for a health check, Amazon Route 53 associates the health check with all the resource record
         * sets that you specify in <code>DnsConfig</code>.
         * </p>
         * <note>
         * <p>
         * The health check uses 30 seconds as the request interval. This is the number of seconds between the time that
         * each Amazon Route 53 health checker gets a response from your endpoint and the time that it sends the next
         * health check request. A health checker in each data center around the world sends your endpoint a health
         * check request every 30 seconds. On average, your endpoint receives a health check request about every two
         * seconds. Health checkers in different data centers don't coordinate with one another, so you'll sometimes see
         * several requests per second followed by a few seconds with no health checks at all.
         * </p>
         * </note>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/route53/pricing">Amazon Route 53 Pricing</a>.
         * </p>
         * 
         * @param healthCheckConfig
         *        <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check.
         *        If you specify settings for a health check, Amazon Route 53 associates the health check with all the
         *        resource record sets that you specify in <code>DnsConfig</code>.</p> <note>
         *        <p>
         *        The health check uses 30 seconds as the request interval. This is the number of seconds between the
         *        time that each Amazon Route 53 health checker gets a response from your endpoint and the time that it
         *        sends the next health check request. A health checker in each data center around the world sends your
         *        endpoint a health check request every 30 seconds. On average, your endpoint receives a health check
         *        request about every two seconds. Health checkers in different data centers don't coordinate with one
         *        another, so you'll sometimes see several requests per second followed by a few seconds with no health
         *        checks at all.
         *        </p>
         *        </note>
         *        <p>
         *        For information about the charges for health checks, see <a
         *        href="http://aws.amazon.com/route53/pricing">Amazon Route 53 Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If you
         * specify settings for a health check, Amazon Route 53 associates the health check with all the resource record
         * sets that you specify in <code>DnsConfig</code>.
         * </p>
         * <note>
         * <p>
         * The health check uses 30 seconds as the request interval. This is the number of seconds between the time that
         * each Amazon Route 53 health checker gets a response from your endpoint and the time that it sends the next
         * health check request. A health checker in each data center around the world sends your endpoint a health
         * check request every 30 seconds. On average, your endpoint receives a health check request about every two
         * seconds. Health checkers in different data centers don't coordinate with one another, so you'll sometimes see
         * several requests per second followed by a few seconds with no health checks at all.
         * </p>
         * </note>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/route53/pricing">Amazon Route 53 Pricing</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().apply(healthCheckConfig).build());
        }

        /**
         * <p>
         * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param createDate
         *        The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * An optional parameter that you can use to resolve concurrent creation requests. <code>CreatorRequestId</code>
         * helps to determine if a specific client owns the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        An optional parameter that you can use to resolve concurrent creation requests.
         *        <code>CreatorRequestId</code> helps to determine if a specific client owns the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private Integer instanceCount;

        private DnsConfig dnsConfig;

        private HealthCheckConfig healthCheckConfig;

        private Instant createDate;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            instanceCount(model.instanceCount);
            dnsConfig(model.dnsConfig);
            healthCheckConfig(model.healthCheckConfig);
            createDate(model.createDate);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public Service build() {
            return new Service(this);
        }
    }
}
