/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service can't be created because a service with the same name already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ServiceAlreadyExistsException extends ServiceDiscoveryException implements
        ToCopyableBuilder<ServiceAlreadyExistsException.Builder, ServiceAlreadyExistsException> {
    private final String creatorRequestId;

    private final String serviceId;

    private ServiceAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.creatorRequestId = builder.creatorRequestId;
        this.serviceId = builder.serviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The <code>CreatorRequestId</code> that was used to create the service.
     * </p>
     * 
     * @return The <code>CreatorRequestId</code> that was used to create the service.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the existing service.
     * </p>
     * 
     * @return The ID of the existing service.
     */
    public String serviceId() {
        return serviceId;
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceAlreadyExistsException> {
        /**
         * <p>
         * The <code>CreatorRequestId</code> that was used to create the service.
         * </p>
         * 
         * @param creatorRequestId
         *        The <code>CreatorRequestId</code> that was used to create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the existing service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the existing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String creatorRequestId;

        private String serviceId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAlreadyExistsException model) {
            creatorRequestId(model.creatorRequestId);
            serviceId(model.serviceId);
            this.message = model.getMessage();
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @JsonProperty("CreatorRequestId")
        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @JsonProperty("ServiceId")
        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ServiceAlreadyExistsException build() {
            return new ServiceAlreadyExistsException(this);
        }
    }
}
