/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.transform;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicediscovery.model.Operation;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Operation} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OperationMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();

    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> UPDATEDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateDate").isBinary(false).build();

    private static final MarshallingInfo<Map> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();

    private static final OperationMarshaller INSTANCE = new OperationMarshaller();

    private OperationMarshaller() {
    }

    public static OperationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Operation operation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(operation, "operation");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(operation.id(), ID_BINDING);
            protocolMarshaller.marshall(operation.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall(operation.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall(operation.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(operation.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall(operation.createDate(), CREATEDATE_BINDING);
            protocolMarshaller.marshall(operation.updateDate(), UPDATEDATE_BINDING);
            protocolMarshaller.marshall(operation.targetsStrings(), TARGETS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
