/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.servicediscovery.model.HealthStatus;
import software.amazon.awssdk.services.servicediscovery.model.InstanceHealthStatusMapCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstancesHealthStatusResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
    private final Map<String, String> status;
    private final String nextToken;

    private GetInstancesHealthStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    public Map<String, HealthStatus> status() {
        return TypeConverter.convert(this.status, Function.identity(), HealthStatus::fromValue, (k, v) -> true);
    }

    public Map<String, String> statusStrings() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesHealthStatusResponse)) {
            return false;
        }
        GetInstancesHealthStatusResponse other = (GetInstancesHealthStatusResponse)((Object)obj);
        return Objects.equals(this.statusStrings(), other.statusStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInstancesHealthStatusResponse").add("Status", this.statusStrings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.statusStrings()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private Map<String, String> status;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesHealthStatusResponse model) {
            this.status(model.status);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
            return this;
        }

        public final void setStatus(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInstancesHealthStatusResponse build() {
            return new GetInstancesHealthStatusResponse(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    CopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
        public Builder status(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

