/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.services.servicediscovery.transform.ServiceChangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServiceChange
implements StructuredPojo,
ToCopyableBuilder<Builder, ServiceChange> {
    private final String description;
    private final DnsConfigChange dnsConfig;
    private final HealthCheckConfig healthCheckConfig;

    private ServiceChange(BuilderImpl builder) {
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    public String description() {
        return this.description;
    }

    public DnsConfigChange dnsConfig() {
        return this.dnsConfig;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceChange)) {
            return false;
        }
        ServiceChange other = (ServiceChange)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsConfig(), other.dnsConfig()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig());
    }

    public String toString() {
        return ToString.builder((String)"ServiceChange").add("Description", (Object)this.description()).add("DnsConfig", (Object)this.dnsConfig()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DnsConfig": {
                return Optional.of(clazz.cast(this.dnsConfig()));
            }
            case "HealthCheckConfig": {
                return Optional.of(clazz.cast(this.healthCheckConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private DnsConfigChange dnsConfig;
        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceChange model) {
            this.description(model.description);
            this.dnsConfig(model.dnsConfig);
            this.healthCheckConfig(model.healthCheckConfig);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfigChange.Builder getDnsConfig() {
            return this.dnsConfig != null ? this.dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfigChange dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfigChange.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public ServiceChange build() {
            return new ServiceChange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServiceChange> {
        public Builder description(String var1);

        public Builder dnsConfig(DnsConfigChange var1);

        default public Builder dnsConfig(Consumer<DnsConfigChange.Builder> dnsConfig) {
            return this.dnsConfig((DnsConfigChange)((DnsConfigChange.Builder)DnsConfigChange.builder().apply(dnsConfig)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().apply(healthCheckConfig)).build());
        }
    }
}

