/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrivateDnsNamespaceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<CreatePrivateDnsNamespaceRequest.Builder, CreatePrivateDnsNamespaceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePrivateDnsNamespaceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePrivateDnsNamespaceRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePrivateDnsNamespaceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePrivateDnsNamespaceRequest::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CREATOR_REQUEST_ID_FIELD, DESCRIPTION_FIELD, VPC_FIELD));

    private final String name;

    private final String creatorRequestId;

    private final String description;

    private final String vpc;

    private CreatePrivateDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53 automatically
     * creates a hosted zone that has the same name as the namespace.
     * </p>
     * 
     * @return The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
     *         automatically creates a hosted zone that has the same name as the namespace.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code>
     * requests to be retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can be
     * any unique string, for example, a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code>
     *         requests to be retried without the risk of executing the operation twice. <code>CreatorRequestId</code>
     *         can be any unique string, for example, a date/time stamp.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A description for the namespace.
     * </p>
     * 
     * @return A description for the namespace.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon VPC that you want to associate the namespace with.
     * </p>
     * 
     * @return The ID of the Amazon VPC that you want to associate the namespace with.
     */
    public String vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateDnsNamespaceRequest)) {
            return false;
        }
        CreatePrivateDnsNamespaceRequest other = (CreatePrivateDnsNamespaceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(description(), other.description()) && Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePrivateDnsNamespaceRequest").add("Name", name())
                .add("CreatorRequestId", creatorRequestId()).add("Description", description()).add("Vpc", vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivateDnsNamespaceRequest, T> g) {
        return obj -> g.apply((CreatePrivateDnsNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
        /**
         * <p>
         * The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
         * automatically creates a hosted zone that has the same name as the namespace.
         * </p>
         * 
         * @param name
         *        The name that you want to assign to this namespace. When you create a namespace, Amazon Route 53
         *        automatically creates a hosted zone that has the same name as the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>CreatePrivateDnsNamespace</code>
         * requests to be retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can
         * be any unique string, for example, a date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed
         *        <code>CreatePrivateDnsNamespace</code> requests to be retried without the risk of executing the
         *        operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
         *        stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A description for the namespace.
         * </p>
         * 
         * @param description
         *        A description for the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon VPC that you want to associate the namespace with.
         * </p>
         * 
         * @param vpc
         *        The ID of the Amazon VPC that you want to associate the namespace with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String name;

        private String creatorRequestId;

        private String description;

        private String vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateDnsNamespaceRequest model) {
            super(model);
            name(model.name);
            creatorRequestId(model.creatorRequestId);
            description(model.description);
            vpc(model.vpc);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpc() {
            return vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateDnsNamespaceRequest build() {
            return new CreatePrivateDnsNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
