/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckCustomConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckCustomConfig.Builder, HealthCheckCustomConfig> {
    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheckCustomConfig::failureThreshold)).setter(setter(Builder::failureThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer failureThreshold;

    private HealthCheckCustomConfig(BuilderImpl builder) {
        this.failureThreshold = builder.failureThreshold;
    }

    /**
     * Returns the value of the FailureThreshold property for this object.
     * 
     * @return The value of the FailureThreshold property for this object.
     */
    public Integer failureThreshold() {
        return failureThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckCustomConfig)) {
            return false;
        }
        HealthCheckCustomConfig other = (HealthCheckCustomConfig) obj;
        return Objects.equals(failureThreshold(), other.failureThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("HealthCheckCustomConfig").add("FailureThreshold", failureThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckCustomConfig, T> g) {
        return obj -> g.apply((HealthCheckCustomConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckCustomConfig> {
        /**
         * Sets the value of the FailureThreshold property for this object.
         *
         * @param failureThreshold
         *        The new value for the FailureThreshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThreshold(Integer failureThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckCustomConfig model) {
            failureThreshold(model.failureThreshold);
        }

        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public HealthCheckCustomConfig build() {
            return new HealthCheckCustomConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
