/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information that is specific to the namespace type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<NamespaceProperties.Builder, NamespaceProperties> {
    private static final SdkField<DnsProperties> DNS_PROPERTIES_FIELD = SdkField
            .<DnsProperties> builder(MarshallingType.SDK_POJO).getter(getter(NamespaceProperties::dnsProperties))
            .setter(setter(Builder::dnsProperties)).constructor(DnsProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final DnsProperties dnsProperties;

    private NamespaceProperties(BuilderImpl builder) {
        this.dnsProperties = builder.dnsProperties;
    }

    /**
     * <p>
     * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
     * </p>
     * 
     * @return A complex type that contains the ID for the hosted zone that Route 53 creates when you create a
     *         namespace.
     */
    public DnsProperties dnsProperties() {
        return dnsProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceProperties)) {
            return false;
        }
        NamespaceProperties other = (NamespaceProperties) obj;
        return Objects.equals(dnsProperties(), other.dnsProperties());
    }

    @Override
    public String toString() {
        return ToString.builder("NamespaceProperties").add("DnsProperties", dnsProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsProperties":
            return Optional.ofNullable(clazz.cast(dnsProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceProperties, T> g) {
        return obj -> g.apply((NamespaceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceProperties> {
        /**
         * <p>
         * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
         * </p>
         * 
         * @param dnsProperties
         *        A complex type that contains the ID for the hosted zone that Route 53 creates when you create a
         *        namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsProperties(DnsProperties dnsProperties);

        /**
         * <p>
         * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsProperties.Builder} avoiding the need to
         * create one manually via {@link DnsProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsProperties(DnsProperties)}.
         * 
         * @param dnsProperties
         *        a consumer that will call methods on {@link DnsProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsProperties(DnsProperties)
         */
        default Builder dnsProperties(Consumer<DnsProperties.Builder> dnsProperties) {
            return dnsProperties(DnsProperties.builder().applyMutation(dnsProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DnsProperties dnsProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceProperties model) {
            dnsProperties(model.dnsProperties);
        }

        public final DnsProperties.Builder getDnsProperties() {
            return dnsProperties != null ? dnsProperties.toBuilder() : null;
        }

        @Override
        public final Builder dnsProperties(DnsProperties dnsProperties) {
            this.dnsProperties = dnsProperties;
            return this;
        }

        public final void setDnsProperties(DnsProperties.BuilderImpl dnsProperties) {
            this.dnsProperties = dnsProperties != null ? dnsProperties.build() : null;
        }

        @Override
        public NamespaceProperties build() {
            return new NamespaceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
