/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains changes to an existing service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceChange implements SdkPojo, Serializable, ToCopyableBuilder<ServiceChange.Builder, ServiceChange> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceChange::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DnsConfigChange> DNS_CONFIG_FIELD = SdkField
            .<DnsConfigChange> builder(MarshallingType.SDK_POJO).getter(getter(ServiceChange::dnsConfig))
            .setter(setter(Builder::dnsConfig)).constructor(DnsConfigChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO).getter(getter(ServiceChange::healthCheckConfig))
            .setter(setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DNS_CONFIG_FIELD, HEALTH_CHECK_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final DnsConfigChange dnsConfig;

    private final HealthCheckConfig healthCheckConfig;

    private ServiceChange(BuilderImpl builder) {
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    /**
     * <p>
     * A description for the service.
     * </p>
     * 
     * @return A description for the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A complex type that contains information about the records that you want Route 53 to create when you register an
     * instance.
     * </p>
     * 
     * @return A complex type that contains information about the records that you want Route 53 to create when you
     *         register an instance.
     */
    public DnsConfigChange dnsConfig() {
        return dnsConfig;
    }

    /**
     * Returns the value of the HealthCheckConfig property for this object.
     * 
     * @return The value of the HealthCheckConfig property for this object.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceChange)) {
            return false;
        }
        ServiceChange other = (ServiceChange) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("ServiceChange").add("Description", description()).add("DnsConfig", dnsConfig())
                .add("HealthCheckConfig", healthCheckConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DnsConfig":
            return Optional.ofNullable(clazz.cast(dnsConfig()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceChange, T> g) {
        return obj -> g.apply((ServiceChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceChange> {
        /**
         * <p>
         * A description for the service.
         * </p>
         * 
         * @param description
         *        A description for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A complex type that contains information about the records that you want Route 53 to create when you register
         * an instance.
         * </p>
         * 
         * @param dnsConfig
         *        A complex type that contains information about the records that you want Route 53 to create when you
         *        register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfigChange dnsConfig);

        /**
         * <p>
         * A complex type that contains information about the records that you want Route 53 to create when you register
         * an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsConfigChange.Builder} avoiding the need to
         * create one manually via {@link DnsConfigChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfigChange.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsConfig(DnsConfigChange)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfigChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfigChange)
         */
        default Builder dnsConfig(Consumer<DnsConfigChange.Builder> dnsConfig) {
            return dnsConfig(DnsConfigChange.builder().applyMutation(dnsConfig).build());
        }

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * @param healthCheckConfig
         *        The new value for the HealthCheckConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private DnsConfigChange dnsConfig;

        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceChange model) {
            description(model.description);
            dnsConfig(model.dnsConfig);
            healthCheckConfig(model.healthCheckConfig);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfigChange.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfigChange dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfigChange.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public ServiceChange build() {
            return new ServiceChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
