/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The namespace that you're trying to create already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceAlreadyExistsException extends ServiceDiscoveryException implements
        ToCopyableBuilder<NamespaceAlreadyExistsException.Builder, NamespaceAlreadyExistsException> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NamespaceAlreadyExistsException::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NamespaceAlreadyExistsException::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            NAMESPACE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creatorRequestId;

    private final String namespaceId;

    private NamespaceAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.namespaceId = builder.namespaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The <code>CreatorRequestId</code> that was used to create the namespace.
     * </p>
     * 
     * @return The <code>CreatorRequestId</code> that was used to create the namespace.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the existing namespace.
     * </p>
     * 
     * @return The ID of the existing namespace.
     */
    public String namespaceId() {
        return namespaceId;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceAlreadyExistsException, T> g) {
        return obj -> g.apply((NamespaceAlreadyExistsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceAlreadyExistsException>,
            ServiceDiscoveryException.Builder {
        /**
         * <p>
         * The <code>CreatorRequestId</code> that was used to create the namespace.
         * </p>
         * 
         * @param creatorRequestId
         *        The <code>CreatorRequestId</code> that was used to create the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the existing namespace.
         * </p>
         * 
         * @param namespaceId
         *        The ID of the existing namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ServiceDiscoveryException.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String namespaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceAlreadyExistsException model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            namespaceId(model.namespaceId);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public NamespaceAlreadyExistsException build() {
            return new NamespaceAlreadyExistsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
