/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the instances that you registered by using a specified service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSummary implements SdkPojo, Serializable, ToCopyableBuilder<InstanceSummary.Builder, InstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(InstanceSummary::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Map<String, String> attributes;

    private InstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The ID for an instance that you created by using a specified service.
     * </p>
     * 
     * @return The ID for an instance that you created by using a specified service.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A string map that contains the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The attributes that are associate with the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each attribute, the applicable value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported attribute keys include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS_ALIAS_DNS_NAME</code>: For an alias record that routes traffic to an Elastic Load Balancing load
     * balancer, the DNS name that is associated with the load balancer.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_CNAME</code>: For a CNAME record, the domain name that Route 53 returns in response to DNS
     * queries, for example, <code>example.com</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_IPV4</code>: For an A record, the IPv4 address that Route 53 returns in response to DNS
     * queries, for example, <code>192.0.2.44</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_IPV6</code>: For an AAAA record, the IPv6 address that Route 53 returns in response to DNS
     * queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_INSTANCE_PORT</code>: For an SRV record, the value that Route 53 returns for the port. In addition, if
     * the service includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string map that contains the following information:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The attributes that are associate with the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each attribute, the applicable value.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported attribute keys include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS_ALIAS_DNS_NAME</code>: For an alias record that routes traffic to an Elastic Load Balancing
     *         load balancer, the DNS name that is associated with the load balancer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_CNAME</code>: For a CNAME record, the domain name that Route 53 returns in response to
     *         DNS queries, for example, <code>example.com</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_IPV4</code>: For an A record, the IPv4 address that Route 53 returns in response to
     *         DNS queries, for example, <code>192.0.2.44</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_IPV6</code>: For an AAAA record, the IPv6 address that Route 53 returns in response to
     *         DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_INSTANCE_PORT</code>: For an SRV record, the value that Route 53 returns for the port. In
     *         addition, if the service includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53
     *         sends requests to.
     *         </p>
     *         </li>
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceSummary").add("Id", id()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSummary> {
        /**
         * <p>
         * The ID for an instance that you created by using a specified service.
         * </p>
         * 
         * @param id
         *        The ID for an instance that you created by using a specified service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A string map that contains the following information:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The attributes that are associate with the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each attribute, the applicable value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported attribute keys include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS_ALIAS_DNS_NAME</code>: For an alias record that routes traffic to an Elastic Load Balancing load
         * balancer, the DNS name that is associated with the load balancer.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_CNAME</code>: For a CNAME record, the domain name that Route 53 returns in response to DNS
         * queries, for example, <code>example.com</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_IPV4</code>: For an A record, the IPv4 address that Route 53 returns in response to DNS
         * queries, for example, <code>192.0.2.44</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_IPV6</code>: For an AAAA record, the IPv6 address that Route 53 returns in response to DNS
         * queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_INSTANCE_PORT</code>: For an SRV record, the value that Route 53 returns for the port. In addition,
         * if the service includes <code>HealthCheckConfig</code>, the port on the endpoint that Route 53 sends requests
         * to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributes
         *        A string map that contains the following information:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The attributes that are associate with the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each attribute, the applicable value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported attribute keys include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS_ALIAS_DNS_NAME</code>: For an alias record that routes traffic to an Elastic Load Balancing
         *        load balancer, the DNS name that is associated with the load balancer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_CNAME</code>: For a CNAME record, the domain name that Route 53 returns in response
         *        to DNS queries, for example, <code>example.com</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_IPV4</code>: For an A record, the IPv4 address that Route 53 returns in response to
         *        DNS queries, for example, <code>192.0.2.44</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_IPV6</code>: For an AAAA record, the IPv6 address that Route 53 returns in response
         *        to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_INSTANCE_PORT</code>: For an SRV record, the value that Route 53 returns for the port. In
         *        addition, if the service includes <code>HealthCheckConfig</code>, the port on the endpoint that Route
         *        53 sends requests to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            id(model.id);
            attributes(model.attributes);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
