/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<ListOperationsRequest.Builder, ListOperationsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOperationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListOperationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<OperationFilter>> FILTERS_FIELD = SdkField
            .<List<OperationFilter>> builder(MarshallingType.LIST)
            .getter(getter(ListOperationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<OperationFilter> filters;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * For the first <code>ListOperations</code> request, omit this value.
     * </p>
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get the
     * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
     * request.
     * </p>
     * <note>
     * <p>
     * AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria. It's
     * possible that no operations in the first <code>MaxResults</code> operations matched the specified criteria but
     * that subsequent groups of <code>MaxResults</code> operations do contain operations that match the criteria.
     * </p>
     * </note>
     * 
     * @return For the first <code>ListOperations</code> request, omit this value.</p>
     *         <p>
     *         If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to
     *         get the next group of results. Specify the value of <code>NextToken</code> from the previous response in
     *         the next request.
     *         </p>
     *         <note>
     *         <p>
     *         AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified
     *         criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the
     *         specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations
     *         that match the criteria.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items that you want AWS Cloud Map to return in the response to a
     * <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
     * returns up to 100 operations.
     * </p>
     * 
     * @return The maximum number of items that you want AWS Cloud Map to return in the response to a
     *         <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud
     *         Map returns up to 100 operations.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains specifications for the operations that you want to list, for example, operations
     * that you started between a specified start date and end date.
     * </p>
     * <p>
     * If you specify more than one filter, an operation must match all filters to be returned by
     * <code>ListOperations</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains specifications for the operations that you want to list, for example,
     *         operations that you started between a specified start date and end date.</p>
     *         <p>
     *         If you specify more than one filter, an operation must match all filters to be returned by
     *         <code>ListOperations</code>.
     */
    public List<OperationFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOperationsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsRequest, T> g) {
        return obj -> g.apply((ListOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationsRequest> {
        /**
         * <p>
         * For the first <code>ListOperations</code> request, omit this value.
         * </p>
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to get
         * the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified criteria.
         * It's possible that no operations in the first <code>MaxResults</code> operations matched the specified
         * criteria but that subsequent groups of <code>MaxResults</code> operations do contain operations that match
         * the criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        For the first <code>ListOperations</code> request, omit this value.</p>
         *        <p>
         *        If the response contains <code>NextToken</code>, submit another <code>ListOperations</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.
         *        </p>
         *        <note>
         *        <p>
         *        AWS Cloud Map gets <code>MaxResults</code> operations and then filters them based on the specified
         *        criteria. It's possible that no operations in the first <code>MaxResults</code> operations matched the
         *        specified criteria but that subsequent groups of <code>MaxResults</code> operations do contain
         *        operations that match the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items that you want AWS Cloud Map to return in the response to a
         * <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
         * returns up to 100 operations.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items that you want AWS Cloud Map to return in the response to a
         *        <code>ListOperations</code> request. If you don't specify a value for <code>MaxResults</code>, AWS
         *        Cloud Map returns up to 100 operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A complex type that contains specifications for the operations that you want to list, for example, operations
         * that you started between a specified start date and end date.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListOperations</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the operations that you want to list, for example,
         *        operations that you started between a specified start date and end date.</p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListOperations</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OperationFilter> filters);

        /**
         * <p>
         * A complex type that contains specifications for the operations that you want to list, for example, operations
         * that you started between a specified start date and end date.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListOperations</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the operations that you want to list, for example,
         *        operations that you started between a specified start date and end date.</p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListOperations</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OperationFilter... filters);

        /**
         * <p>
         * A complex type that contains specifications for the operations that you want to list, for example, operations
         * that you started between a specified start date and end date.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListOperations</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OperationFilter>.Builder} avoiding the need
         * to create one manually via {@link List<OperationFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperationFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<OperationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<OperationFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<OperationFilter>)
         */
        Builder filters(Consumer<OperationFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<OperationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<OperationFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(OperationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<OperationFilter> filters) {
            this.filters = OperationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OperationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OperationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OperationFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<OperationFilter.BuilderImpl> filters) {
            this.filters = OperationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
