/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateServiceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<ServiceChange> SERVICE_FIELD = SdkField.<ServiceChange> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateServiceRequest::service)).setter(setter(Builder::service)).constructor(ServiceChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SERVICE_FIELD));

    private final String id;

    private final ServiceChange service;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.service = builder.service;
    }

    /**
     * <p>
     * The ID of the service that you want to update.
     * </p>
     * 
     * @return The ID of the service that you want to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A complex type that contains the new settings for the service.
     * </p>
     * 
     * @return A complex type that contains the new settings for the service.
     */
    public ServiceChange service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateServiceRequest").add("Id", id()).add("Service", service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The ID of the service that you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the service that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A complex type that contains the new settings for the service.
         * </p>
         * 
         * @param service
         *        A complex type that contains the new settings for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ServiceChange service);

        /**
         * <p>
         * A complex type that contains the new settings for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceChange.Builder} avoiding the need to
         * create one manually via {@link ServiceChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceChange.Builder#build()} is called immediately and its
         * result is passed to {@link #service(ServiceChange)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link ServiceChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(ServiceChange)
         */
        default Builder service(Consumer<ServiceChange.Builder> service) {
            return service(ServiceChange.builder().applyMutation(service).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String id;

        private ServiceChange service;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            id(model.id);
            service(model.service);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ServiceChange.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        @Override
        public final Builder service(ServiceChange service) {
            this.service = service;
            return this;
        }

        public final void setService(ServiceChange.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
