/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional health check. If you specify
 * settings for a health check, AWS Cloud Map associates the health check with the records that you specify in
 * <code>DnsConfig</code>.
 * </p>
 * <important>
 * <p>
 * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
 * <code>HealthCheckConfig</code> but not both.
 * </p>
 * </important>
 * <p>
 * Health checks are basic Route 53 health checks that monitor an AWS endpoint. For information about pricing for health
 * checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
 * </p>
 * <p>
 * Note the following about configuring health checks.
 * </p>
 * <p>
 * <b>A and AAAA records</b>
 * </p>
 * <p>
 * If <code>DnsConfig</code> includes configurations for both A and AAAA records, AWS Cloud Map creates a health check
 * that uses the IPv4 address to check the health of the resource. If the endpoint that is specified by the IPv4 address
 * is unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
 * </p>
 * <p>
 * <b>CNAME records</b>
 * </p>
 * <p>
 * You can't specify settings for <code>HealthCheckConfig</code> when the <code>DNSConfig</code> includes
 * <code>CNAME</code> for the value of <code>Type</code>. If you do, the <code>CreateService</code> request will fail
 * with an <code>InvalidInput</code> error.
 * </p>
 * <p>
 * <b>Request interval</b>
 * </p>
 * <p>
 * A Route 53 health checker in each health-checking region sends a health check request to an endpoint every 30
 * seconds. On average, your endpoint receives a health check request about every two seconds. However, health checkers
 * don't coordinate with one another, so you'll sometimes see several requests per second followed by a few seconds with
 * no health checks at all.
 * </p>
 * <p>
 * <b>Health checking regions</b>
 * </p>
 * <p>
 * Health checkers perform checks from all Route 53 health-checking regions. For a list of the current regions, see <a
 * href=
 * "http://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions"
 * >Regions</a>.
 * </p>
 * <p>
 * <b>Alias records</b>
 * </p>
 * <p>
 * When you register an instance, if you include the <code>AWS_ALIAS_DNS_NAME</code> attribute, AWS Cloud Map creates a
 * Route 53 alias record. Note the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Route 53 automatically sets <code>EvaluateTargetHealth</code> to true for alias records. When
 * <code>EvaluateTargetHealth</code> is true, the alias record inherits the health of the referenced AWS resource. such
 * as an ELB load balancer. For more information, see <a href=
 * "http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth"
 * >EvaluateTargetHealth</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you include <code>HealthCheckConfig</code> and then use the service to register an instance that creates an alias
 * record, Route 53 doesn't create the health check.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Charges for health checks</b>
 * </p>
 * <p>
 * Health checks are basic Route 53 health checks that monitor an AWS endpoint. For information about pricing for health
 * checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckConfig.Builder, HealthCheckConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HealthCheckConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> RESOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HealthCheckConfig::resourcePath)).setter(setter(Builder::resourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePath").build()).build();

    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HealthCheckConfig::failureThreshold)).setter(setter(Builder::failureThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            RESOURCE_PATH_FIELD, FAILURE_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String resourcePath;

    private final Integer failureThreshold;

    private HealthCheckConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.failureThreshold = builder.failureThreshold;
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
     * healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>TCP</b>: Route 53 tries to establish a TCP connection.
     * </p>
     * <p>
     * If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for <code>ResourcePath</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Route 53 determines whether an
     *         endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Route 53 tries to establish a TCP connection.
     *         </p>
     *         <p>
     *         If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
     *         <code>ResourcePath</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     * @see HealthCheckType
     */
    public HealthCheckType type() {
        return HealthCheckType.fromValue(type);
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is
     * healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>TCP</b>: Route 53 tries to establish a TCP connection.
     * </p>
     * <p>
     * If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for <code>ResourcePath</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Route 53 determines whether an
     *         endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Route 53 tries to establish a TCP connection.
     *         </p>
     *         <p>
     *         If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
     *         <code>ResourcePath</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     * @see HealthCheckType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The path that you want Route 53 to request when performing health checks. The path can be any value for which
     * your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, such as the file
     * <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If you
     * don't specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.
     * </p>
     * <p>
     * If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
     * <code>ResourcePath</code>.
     * </p>
     * 
     * @return The path that you want Route 53 to request when performing health checks. The path can be any value for
     *         which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, such as
     *         the file <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the
     *         service. If you don't specify a value for <code>ResourcePath</code>, the default value is <code>/</code>
     *         .</p>
     *         <p>
     *         If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
     *         <code>ResourcePath</code>.
     */
    public String resourcePath() {
        return resourcePath;
    }

    /**
     * <p>
     * The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
     * status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     * </p>
     * 
     * @return The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the
     *         current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
     */
    public Integer failureThreshold() {
        return failureThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourcePath(), other.resourcePath())
                && Objects.equals(failureThreshold(), other.failureThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HealthCheckConfig").add("Type", typeAsString()).add("ResourcePath", resourcePath())
                .add("FailureThreshold", failureThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourcePath":
            return Optional.ofNullable(clazz.cast(resourcePath()));
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfig, T> g) {
        return obj -> g.apply((HealthCheckConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckConfig> {
        /**
         * <p>
         * The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint
         * is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>TCP</b>: Route 53 tries to establish a TCP connection.
         * </p>
         * <p>
         * If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for <code>ResourcePath</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Route 53 determines whether an
         *        endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Route 53 tries to establish a TCP connection.
         *        </p>
         *        <p>
         *        If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
         *        <code>ResourcePath</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint
         * is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>TCP</b>: Route 53 tries to establish a TCP connection.
         * </p>
         * <p>
         * If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for <code>ResourcePath</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Route 53 determines whether an
         *        endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify HTTPS for the value of <code>Type</code>, the endpoint must support TLS v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Route 53 tries to establish a TCP connection.
         *        </p>
         *        <p>
         *        If you specify <code>TCP</code> for <code>Type</code>, don't specify a value for
         *        <code>ResourcePath</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(HealthCheckType type);

        /**
         * <p>
         * The path that you want Route 53 to request when performing health checks. The path can be any value for which
         * your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, such as the file
         * <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS name for the service. If
         * you don't specify a value for <code>ResourcePath</code>, the default value is <code>/</code>.
         * </p>
         * <p>
         * If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
         * <code>ResourcePath</code>.
         * </p>
         * 
         * @param resourcePath
         *        The path that you want Route 53 to request when performing health checks. The path can be any value
         *        for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy,
         *        such as the file <code>/docs/route53-health-check.html</code>. Route 53 automatically adds the DNS
         *        name for the service. If you don't specify a value for <code>ResourcePath</code>, the default value is
         *        <code>/</code>.</p>
         *        <p>
         *        If you specify <code>TCP</code> for <code>Type</code>, you must <i>not</i> specify a value for
         *        <code>ResourcePath</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePath(String resourcePath);

        /**
         * <p>
         * The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the current
         * status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
         * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param failureThreshold
         *        The number of consecutive health checks that an endpoint must pass or fail for Route 53 to change the
         *        current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Route 53 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThreshold(Integer failureThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String resourcePath;

        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            type(model.type);
            resourcePath(model.resourcePath);
            failureThreshold(model.failureThreshold);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResourcePath() {
            return resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
