/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverInstancesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<DiscoverInstancesResponse.Builder, DiscoverInstancesResponse> {
    private static final SdkField<List<HttpInstanceSummary>> INSTANCES_FIELD = SdkField
            .<List<HttpInstanceSummary>> builder(MarshallingType.LIST)
            .getter(getter(DiscoverInstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD));

    private final List<HttpInstanceSummary> instances;

    private DiscoverInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
     */
    public List<HttpInstanceSummary> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesResponse)) {
            return false;
        }
        DiscoverInstancesResponse other = (DiscoverInstancesResponse) obj;
        return Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DiscoverInstancesResponse").add("Instances", instances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesResponse, T> g) {
        return obj -> g.apply((DiscoverInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DiscoverInstancesResponse> {
        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * 
         * @param instances
         *        A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<HttpInstanceSummary> instances);

        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * 
         * @param instances
         *        A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(HttpInstanceSummary... instances);

        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HttpInstanceSummary>.Builder} avoiding the
         * need to create one manually via {@link List<HttpInstanceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpInstanceSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #instances(List<HttpInstanceSummary>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<HttpInstanceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<HttpInstanceSummary>)
         */
        Builder instances(Consumer<HttpInstanceSummary.Builder>... instances);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<HttpInstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesResponse model) {
            super(model);
            instances(model.instances);
        }

        public final Collection<HttpInstanceSummary.Builder> getInstances() {
            return instances != null ? instances.stream().map(HttpInstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HttpInstanceSummary> instances) {
            this.instances = HttpInstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HttpInstanceSummary... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HttpInstanceSummary.Builder>... instances) {
            instances(Stream.of(instances).map(c -> HttpInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<HttpInstanceSummary.BuilderImpl> instances) {
            this.instances = HttpInstanceSummaryListCopier.copyFromBuilder(instances);
        }

        @Override
        public DiscoverInstancesResponse build() {
            return new DiscoverInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
