/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the Route 53 DNS records that you want AWS Cloud Map to create when
 * you register an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsRecord implements SdkPojo, Serializable, ToCopyableBuilder<DnsRecord.Builder, DnsRecord> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DnsRecord::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Long> TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(DnsRecord::ttl))
            .setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Long ttl;

    private DnsRecord(BuilderImpl builder) {
        this.type = builder.type;
        this.ttl = builder.ttl;
    }

    /**
     * <p>
     * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV record.
     * You can specify them in any combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
     * records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that has the
     * same name as a CNAME record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an instance,
     * specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you register an
     * instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following values are supported:
     * </p>
     * <p>
     * <b>A</b>
     * </p>
     * <p>
     * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     * </p>
     * <p>
     * <b>AAAA</b>
     * </p>
     * <p>
     * Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
     * </p>
     * <p>
     * <b>CNAME</b>
     * </p>
     * <p>
     * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You specify the domain name that you want to route traffic to when you register an instance. For more
     * information, see <a>RegisterInstanceRequest$Attributes</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't specify both <code>CNAME</code> for <code>Type</code> and settings for <code>HealthCheckConfig</code>.
     * If you do, the request will fail with an <code>InvalidInput</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>SRV</b>
     * </p>
     * <p>
     * Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
     * </p>
     * <p>
     * <code>priority weight port service-hostname</code>
     * </p>
     * <p>
     * Note the following about the values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
     * attribute when you submit a <a>RegisterInstance</a> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>service-hostname</code> is a concatenation of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The value that you specify for <code>InstanceId</code> when you register an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the namespace.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
     * <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
     * <code>service-hostname</code> is:
     * </p>
     * <p>
     * <code>test.backend.example.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
     * <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map automatically
     * creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of
     * <code>service-hostname</code> in the SRV record. You can ignore these records.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource, which indicates the type of value that Route 53 returns in response to DNS
     *         queries.</p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV
     *         record. You can specify them in any combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
     *         records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that
     *         has the same name as a CNAME record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
     *         instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you
     *         register an instance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following values are supported:
     *         </p>
     *         <p>
     *         <b>A</b>
     *         </p>
     *         <p>
     *         Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     *         </p>
     *         <p>
     *         <b>AAAA</b>
     *         </p>
     *         <p>
     *         Route 53 returns the IP address of the resource in IPv6 format, such as
     *         2001:0db8:85a3:0000:0000:abcd:0001:2345.
     *         </p>
     *         <p>
     *         <b>CNAME</b>
     *         </p>
     *         <p>
     *         Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specify the domain name that you want to route traffic to when you register an instance. For more
     *         information, see <a>RegisterInstanceRequest$Attributes</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
     *         <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>SRV</b>
     *         </p>
     *         <p>
     *         Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
     *         </p>
     *         <p>
     *         <code>priority weight port service-hostname</code>
     *         </p>
     *         <p>
     *         Note the following about the values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
     *         changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>port</code> comes from the value that you specify for the
     *         <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a>RegisterInstance</a> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>service-hostname</code> is a concatenation of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The value that you specify for <code>InstanceId</code> when you register an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name of the service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name of the namespace.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
     *         <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
     *         <code>service-hostname</code> is:
     *         </p>
     *         <p>
     *         <code>test.backend.example.com</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
     *         <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
     *         automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the
     *         value of <code>service-hostname</code> in the SRV record. You can ignore these records.
     * @see RecordType
     */
    public RecordType type() {
        return RecordType.fromValue(type);
    }

    /**
     * <p>
     * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV record.
     * You can specify them in any combination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
     * records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that has the
     * same name as a CNAME record.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an instance,
     * specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you register an
     * instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following values are supported:
     * </p>
     * <p>
     * <b>A</b>
     * </p>
     * <p>
     * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     * </p>
     * <p>
     * <b>AAAA</b>
     * </p>
     * <p>
     * Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
     * </p>
     * <p>
     * <b>CNAME</b>
     * </p>
     * <p>
     * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You specify the domain name that you want to route traffic to when you register an instance. For more
     * information, see <a>RegisterInstanceRequest$Attributes</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't specify both <code>CNAME</code> for <code>Type</code> and settings for <code>HealthCheckConfig</code>.
     * If you do, the request will fail with an <code>InvalidInput</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>SRV</b>
     * </p>
     * <p>
     * Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
     * </p>
     * <p>
     * <code>priority weight port service-hostname</code>
     * </p>
     * <p>
     * Note the following about the values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be changed.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
     * attribute when you submit a <a>RegisterInstance</a> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The value of <code>service-hostname</code> is a concatenation of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The value that you specify for <code>InstanceId</code> when you register an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * The name of the namespace.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
     * <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
     * <code>service-hostname</code> is:
     * </p>
     * <p>
     * <code>test.backend.example.com</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
     * <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map automatically
     * creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of
     * <code>service-hostname</code> in the SRV record. You can ignore these records.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecordType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the resource, which indicates the type of value that Route 53 returns in response to DNS
     *         queries.</p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV
     *         record. You can specify them in any combination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
     *         records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that
     *         has the same name as a CNAME record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
     *         instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you
     *         register an instance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following values are supported:
     *         </p>
     *         <p>
     *         <b>A</b>
     *         </p>
     *         <p>
     *         Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
     *         </p>
     *         <p>
     *         <b>AAAA</b>
     *         </p>
     *         <p>
     *         Route 53 returns the IP address of the resource in IPv6 format, such as
     *         2001:0db8:85a3:0000:0000:abcd:0001:2345.
     *         </p>
     *         <p>
     *         <b>CNAME</b>
     *         </p>
     *         <p>
     *         Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specify the domain name that you want to route traffic to when you register an instance. For more
     *         information, see <a>RegisterInstanceRequest$Attributes</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
     *         <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>SRV</b>
     *         </p>
     *         <p>
     *         Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
     *         </p>
     *         <p>
     *         <code>priority weight port service-hostname</code>
     *         </p>
     *         <p>
     *         Note the following about the values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
     *         changed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>port</code> comes from the value that you specify for the
     *         <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a>RegisterInstance</a> request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value of <code>service-hostname</code> is a concatenation of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The value that you specify for <code>InstanceId</code> when you register an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name of the service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The name of the namespace.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
     *         <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
     *         <code>service-hostname</code> is:
     *         </p>
     *         <p>
     *         <code>test.backend.example.com</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
     *         <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
     *         automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the
     *         value of <code>service-hostname</code> in the SRV record. You can ignore these records.
     * @see RecordType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
     * </p>
     * <note>
     * <p>
     * Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias record routes
     * traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a
     * <a>RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the service; you
     * can use a service to register instances that create either alias or non-alias records.
     * </p>
     * </note>
     * 
     * @return The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
     *         <note>
     *         <p>
     *         Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias record
     *         routes traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a
     *         <a>RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the
     *         service; you can use a service to register instances that create either alias or non-alias records.
     *         </p>
     */
    public Long ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord other = (DnsRecord) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(ttl(), other.ttl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DnsRecord").add("Type", typeAsString()).add("TTL", ttl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TTL":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsRecord, T> g) {
        return obj -> g.apply((DnsRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsRecord> {
        /**
         * <p>
         * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV
         * record. You can specify them in any combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
         * records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that has
         * the same name as a CNAME record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
         * instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you register
         * an instance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following values are supported:
         * </p>
         * <p>
         * <b>A</b>
         * </p>
         * <p>
         * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         * </p>
         * <p>
         * <b>AAAA</b>
         * </p>
         * <p>
         * Route 53 returns the IP address of the resource in IPv6 format, such as
         * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
         * </p>
         * <p>
         * <b>CNAME</b>
         * </p>
         * <p>
         * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You specify the domain name that you want to route traffic to when you register an instance. For more
         * information, see <a>RegisterInstanceRequest$Attributes</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
         * <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>SRV</b>
         * </p>
         * <p>
         * Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
         * </p>
         * <p>
         * <code>priority weight port service-hostname</code>
         * </p>
         * <p>
         * Note the following about the values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
         * changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
         * attribute when you submit a <a>RegisterInstance</a> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>service-hostname</code> is a concatenation of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The value that you specify for <code>InstanceId</code> when you register an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name of the service.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name of the namespace.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
         * <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
         * <code>service-hostname</code> is:
         * </p>
         * <p>
         * <code>test.backend.example.com</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
         * <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
         * automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of
         * <code>service-hostname</code> in the SRV record. You can ignore these records.
         * </p>
         * 
         * @param type
         *        The type of the resource, which indicates the type of value that Route 53 returns in response to DNS
         *        queries.</p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one
         *        SRV record. You can specify them in any combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any
         *        other records. This is a limitation of DNS: you can't create a CNAME record and any other type of
         *        record that has the same name as a CNAME record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
         *        instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you
         *        register an instance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following values are supported:
         *        </p>
         *        <p>
         *        <b>A</b>
         *        </p>
         *        <p>
         *        Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         *        </p>
         *        <p>
         *        <b>AAAA</b>
         *        </p>
         *        <p>
         *        Route 53 returns the IP address of the resource in IPv6 format, such as
         *        2001:0db8:85a3:0000:0000:abcd:0001:2345.
         *        </p>
         *        <p>
         *        <b>CNAME</b>
         *        </p>
         *        <p>
         *        Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You specify the domain name that you want to route traffic to when you register an instance. For more
         *        information, see <a>RegisterInstanceRequest$Attributes</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
         *        <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
         *        error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>SRV</b>
         *        </p>
         *        <p>
         *        Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
         *        </p>
         *        <p>
         *        <code>priority weight port service-hostname</code>
         *        </p>
         *        <p>
         *        Note the following about the values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't
         *        be changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>port</code> comes from the value that you specify for the
         *        <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a>RegisterInstance</a> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>service-hostname</code> is a concatenation of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The value that you specify for <code>InstanceId</code> when you register an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name of the service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name of the namespace.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
         *        <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
         *        <code>service-hostname</code> is:
         *        </p>
         *        <p>
         *        <code>test.backend.example.com</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
         *        automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the
         *        value of <code>service-hostname</code> in the SRV record. You can ignore these records.
         * @see RecordType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the resource, which indicates the type of value that Route 53 returns in response to DNS queries.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one SRV
         * record. You can specify them in any combination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any other
         * records. This is a limitation of DNS: you can't create a CNAME record and any other type of record that has
         * the same name as a CNAME record.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
         * instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you register
         * an instance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following values are supported:
         * </p>
         * <p>
         * <b>A</b>
         * </p>
         * <p>
         * Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         * </p>
         * <p>
         * <b>AAAA</b>
         * </p>
         * <p>
         * Route 53 returns the IP address of the resource in IPv6 format, such as
         * 2001:0db8:85a3:0000:0000:abcd:0001:2345.
         * </p>
         * <p>
         * <b>CNAME</b>
         * </p>
         * <p>
         * Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You specify the domain name that you want to route traffic to when you register an instance. For more
         * information, see <a>RegisterInstanceRequest$Attributes</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
         * <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>SRV</b>
         * </p>
         * <p>
         * Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
         * </p>
         * <p>
         * <code>priority weight port service-hostname</code>
         * </p>
         * <p>
         * Note the following about the values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't be
         * changed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>port</code> comes from the value that you specify for the <code>AWS_INSTANCE_PORT</code>
         * attribute when you submit a <a>RegisterInstance</a> request.
         * </p>
         * </li>
         * <li>
         * <p>
         * The value of <code>service-hostname</code> is a concatenation of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The value that you specify for <code>InstanceId</code> when you register an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name of the service.
         * </p>
         * </li>
         * <li>
         * <p>
         * The name of the namespace.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
         * <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
         * <code>service-hostname</code> is:
         * </p>
         * <p>
         * <code>test.backend.example.com</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>,
         * <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
         * automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the value of
         * <code>service-hostname</code> in the SRV record. You can ignore these records.
         * </p>
         * 
         * @param type
         *        The type of the resource, which indicates the type of value that Route 53 returns in response to DNS
         *        queries.</p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>A, AAAA, and SRV records:</b> You can specify settings for a maximum of one A, one AAAA, and one
         *        SRV record. You can specify them in any combination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CNAME records:</b> If you specify <code>CNAME</code> for <code>Type</code>, you can't define any
         *        other records. This is a limitation of DNS: you can't create a CNAME record and any other type of
         *        record that has the same name as a CNAME record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Alias records:</b> If you want AWS Cloud Map to create a Route 53 alias record when you register an
         *        instance, specify <code>A</code> or <code>AAAA</code> for <code>Type</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>All records:</b> You specify settings other than <code>TTL</code> and <code>Type</code> when you
         *        register an instance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following values are supported:
         *        </p>
         *        <p>
         *        <b>A</b>
         *        </p>
         *        <p>
         *        Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
         *        </p>
         *        <p>
         *        <b>AAAA</b>
         *        </p>
         *        <p>
         *        Route 53 returns the IP address of the resource in IPv6 format, such as
         *        2001:0db8:85a3:0000:0000:abcd:0001:2345.
         *        </p>
         *        <p>
         *        <b>CNAME</b>
         *        </p>
         *        <p>
         *        Route 53 returns the domain name of the resource, such as www.example.com. Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You specify the domain name that you want to route traffic to when you register an instance. For more
         *        information, see <a>RegisterInstanceRequest$Attributes</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must specify <code>WEIGHTED</code> for the value of <code>RoutingPolicy</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't specify both <code>CNAME</code> for <code>Type</code> and settings for
         *        <code>HealthCheckConfig</code>. If you do, the request will fail with an <code>InvalidInput</code>
         *        error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>SRV</b>
         *        </p>
         *        <p>
         *        Route 53 returns the value for an SRV record. The value for an SRV record uses the following values:
         *        </p>
         *        <p>
         *        <code>priority weight port service-hostname</code>
         *        </p>
         *        <p>
         *        Note the following about the values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The values of <code>priority</code> and <code>weight</code> are both set to <code>1</code> and can't
         *        be changed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>port</code> comes from the value that you specify for the
         *        <code>AWS_INSTANCE_PORT</code> attribute when you submit a <a>RegisterInstance</a> request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value of <code>service-hostname</code> is a concatenation of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The value that you specify for <code>InstanceId</code> when you register an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name of the service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The name of the namespace.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, if the value of <code>InstanceId</code> is <code>test</code>, the name of the service is
         *        <code>backend</code>, and the name of the namespace is <code>example.com</code>, the value of
         *        <code>service-hostname</code> is:
         *        </p>
         *        <p>
         *        <code>test.backend.example.com</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify settings for an SRV record and if you specify values for <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both in the <code>RegisterInstance</code> request, AWS Cloud Map
         *        automatically creates <code>A</code> and/or <code>AAAA</code> records that have the same name as the
         *        value of <code>service-hostname</code> in the SRV record. You can ignore these records.
         * @see RecordType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordType
         */
        Builder type(RecordType type);

        /**
         * <p>
         * The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.
         * </p>
         * <note>
         * <p>
         * Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias record
         * routes traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit a
         * <a>RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the service;
         * you can use a service to register instances that create either alias or non-alias records.
         * </p>
         * </note>
         * 
         * @param ttl
         *        The amount of time, in seconds, that you want DNS resolvers to cache the settings for this record.</p>
         *        <note>
         *        <p>
         *        Alias records don't include a TTL because Route 53 uses the TTL for the AWS resource that an alias
         *        record routes traffic to. If you include the <code>AWS_ALIAS_DNS_NAME</code> attribute when you submit
         *        a <a>RegisterInstance</a> request, the <code>TTL</code> value is ignored. Always specify a TTL for the
         *        service; you can use a service to register instances that create either alias or non-alias records.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Long ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRecord model) {
            type(model.type);
            ttl(model.ttl);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecordType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public DnsRecord build() {
            return new DnsRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
