/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNamespaceResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetNamespaceResponse.Builder, GetNamespaceResponse> {
    private static final SdkField<Namespace> NAMESPACE_FIELD = SdkField.<Namespace> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetNamespaceResponse::namespace)).setter(setter(Builder::namespace)).constructor(Namespace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD));

    private final Namespace namespace;

    private GetNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * A complex type that contains information about the specified namespace.
     * </p>
     * 
     * @return A complex type that contains information about the specified namespace.
     */
    public Namespace namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceResponse)) {
            return false;
        }
        GetNamespaceResponse other = (GetNamespaceResponse) obj;
        return Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetNamespaceResponse").add("Namespace", namespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNamespaceResponse, T> g) {
        return obj -> g.apply((GetNamespaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetNamespaceResponse> {
        /**
         * <p>
         * A complex type that contains information about the specified namespace.
         * </p>
         * 
         * @param namespace
         *        A complex type that contains information about the specified namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(Namespace namespace);

        /**
         * <p>
         * A complex type that contains information about the specified namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link Namespace.Builder} avoiding the need to create
         * one manually via {@link Namespace#builder()}.
         *
         * When the {@link Consumer} completes, {@link Namespace.Builder#build()} is called immediately and its result
         * is passed to {@link #namespace(Namespace)}.
         * 
         * @param namespace
         *        a consumer that will call methods on {@link Namespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespace(Namespace)
         */
        default Builder namespace(Consumer<Namespace.Builder> namespace) {
            return namespace(Namespace.builder().applyMutation(namespace).build());
        }
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Namespace namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceResponse model) {
            super(model);
            namespace(model.namespace);
        }

        public final Namespace.Builder getNamespace() {
            return namespace != null ? namespace.toBuilder() : null;
        }

        @Override
        public final Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(Namespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public GetNamespaceResponse build() {
            return new GetNamespaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
