/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSummary implements SdkPojo, Serializable, ToCopyableBuilder<ServiceSummary.Builder, ServiceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ServiceSummary::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<DnsConfig> DNS_CONFIG_FIELD = SdkField.<DnsConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(ServiceSummary::dnsConfig)).setter(setter(Builder::dnsConfig)).constructor(DnsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO).getter(getter(ServiceSummary::healthCheckConfig))
            .setter(setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()).build();

    private static final SdkField<HealthCheckCustomConfig> HEALTH_CHECK_CUSTOM_CONFIG_FIELD = SdkField
            .<HealthCheckCustomConfig> builder(MarshallingType.SDK_POJO).getter(getter(ServiceSummary::healthCheckCustomConfig))
            .setter(setter(Builder::healthCheckCustomConfig)).constructor(HealthCheckCustomConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckCustomConfig").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServiceSummary::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, INSTANCE_COUNT_FIELD, DNS_CONFIG_FIELD, HEALTH_CHECK_CONFIG_FIELD,
            HEALTH_CHECK_CUSTOM_CONFIG_FIELD, CREATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final Integer instanceCount;

    private final DnsConfig dnsConfig;

    private final HealthCheckConfig healthCheckConfig;

    private final HealthCheckCustomConfig healthCheckCustomConfig;

    private final Instant createDate;

    private ServiceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.instanceCount = builder.instanceCount;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckCustomConfig = builder.healthCheckCustomConfig;
        this.createDate = builder.createDate;
    }

    /**
     * <p>
     * The ID that AWS Cloud Map assigned to the service when you created it.
     * </p>
     * 
     * @return The ID that AWS Cloud Map assigned to the service when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service when you create it.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description that you specify when you create the service.
     * </p>
     * 
     * @return The description that you specify when you create the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The number of instances that are currently associated with the service. Instances that were previously associated
     * with the service but that have been deleted are not included in the count.
     * </p>
     * 
     * @return The number of instances that are currently associated with the service. Instances that were previously
     *         associated with the service but that have been deleted are not included in the count.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * Returns the value of the DnsConfig property for this object.
     * 
     * @return The value of the DnsConfig property for this object.
     */
    public DnsConfig dnsConfig() {
        return dnsConfig;
    }

    /**
     * Returns the value of the HealthCheckConfig property for this object.
     * 
     * @return The value of the HealthCheckConfig property for this object.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * Returns the value of the HealthCheckCustomConfig property for this object.
     * 
     * @return The value of the HealthCheckCustomConfig property for this object.
     */
    public HealthCheckCustomConfig healthCheckCustomConfig() {
        return healthCheckCustomConfig;
    }

    /**
     * <p>
     * The date and time that the service was created.
     * </p>
     * 
     * @return The date and time that the service was created.
     */
    public Instant createDate() {
        return createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckCustomConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(healthCheckCustomConfig(), other.healthCheckCustomConfig())
                && Objects.equals(createDate(), other.createDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("InstanceCount", instanceCount()).add("DnsConfig", dnsConfig())
                .add("HealthCheckConfig", healthCheckConfig()).add("HealthCheckCustomConfig", healthCheckCustomConfig())
                .add("CreateDate", createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "DnsConfig":
            return Optional.ofNullable(clazz.cast(dnsConfig()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        case "HealthCheckCustomConfig":
            return Optional.ofNullable(clazz.cast(healthCheckCustomConfig()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSummary, T> g) {
        return obj -> g.apply((ServiceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSummary> {
        /**
         * <p>
         * The ID that AWS Cloud Map assigned to the service when you created it.
         * </p>
         * 
         * @param id
         *        The ID that AWS Cloud Map assigned to the service when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description that you specify when you create the service.
         * </p>
         * 
         * @param description
         *        The description that you specify when you create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of instances that are currently associated with the service. Instances that were previously
         * associated with the service but that have been deleted are not included in the count.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are currently associated with the service. Instances that were previously
         *        associated with the service but that have been deleted are not included in the count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * Sets the value of the DnsConfig property for this object.
         *
         * @param dnsConfig
         *        The new value for the DnsConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfig dnsConfig);

        /**
         * Sets the value of the DnsConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link DnsConfig.Builder} avoiding the need to create
         * one manually via {@link DnsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsConfig(DnsConfig)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfig)
         */
        default Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return dnsConfig(DnsConfig.builder().applyMutation(dnsConfig).build());
        }

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * @param healthCheckConfig
         *        The new value for the HealthCheckConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * Sets the value of the HealthCheckConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }

        /**
         * Sets the value of the HealthCheckCustomConfig property for this object.
         *
         * @param healthCheckCustomConfig
         *        The new value for the HealthCheckCustomConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig);

        /**
         * Sets the value of the HealthCheckCustomConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link HealthCheckCustomConfig.Builder} avoiding the
         * need to create one manually via {@link HealthCheckCustomConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckCustomConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #healthCheckCustomConfig(HealthCheckCustomConfig)}.
         * 
         * @param healthCheckCustomConfig
         *        a consumer that will call methods on {@link HealthCheckCustomConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckCustomConfig(HealthCheckCustomConfig)
         */
        default Builder healthCheckCustomConfig(Consumer<HealthCheckCustomConfig.Builder> healthCheckCustomConfig) {
            return healthCheckCustomConfig(HealthCheckCustomConfig.builder().applyMutation(healthCheckCustomConfig).build());
        }

        /**
         * <p>
         * The date and time that the service was created.
         * </p>
         * 
         * @param createDate
         *        The date and time that the service was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private Integer instanceCount;

        private DnsConfig dnsConfig;

        private HealthCheckConfig healthCheckConfig;

        private HealthCheckCustomConfig healthCheckCustomConfig;

        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            instanceCount(model.instanceCount);
            dnsConfig(model.dnsConfig);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckCustomConfig(model.healthCheckCustomConfig);
            createDate(model.createDate);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final HealthCheckCustomConfig.Builder getHealthCheckCustomConfig() {
            return healthCheckCustomConfig != null ? healthCheckCustomConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig;
            return this;
        }

        public final void setHealthCheckCustomConfig(HealthCheckCustomConfig.BuilderImpl healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig != null ? healthCheckCustomConfig.build() : null;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public ServiceSummary build() {
            return new ServiceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
