/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<CreateServiceRequest.Builder, CreateServiceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceId").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DnsConfig> DNS_CONFIG_FIELD = SdkField.<DnsConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateServiceRequest::dnsConfig)).setter(setter(Builder::dnsConfig)).constructor(DnsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateServiceRequest::healthCheckConfig))
            .setter(setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()).build();

    private static final SdkField<HealthCheckCustomConfig> HEALTH_CHECK_CUSTOM_CONFIG_FIELD = SdkField
            .<HealthCheckCustomConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateServiceRequest::healthCheckCustomConfig)).setter(setter(Builder::healthCheckCustomConfig))
            .constructor(HealthCheckCustomConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckCustomConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            NAMESPACE_ID_FIELD, CREATOR_REQUEST_ID_FIELD, DESCRIPTION_FIELD, DNS_CONFIG_FIELD, HEALTH_CHECK_CONFIG_FIELD,
            HEALTH_CHECK_CUSTOM_CONFIG_FIELD));

    private final String name;

    private final String namespaceId;

    private final String creatorRequestId;

    private final String description;

    private final DnsConfig dnsConfig;

    private final HealthCheckConfig healthCheckConfig;

    private final HealthCheckCustomConfig healthCheckCustomConfig;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.namespaceId = builder.namespaceId;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckCustomConfig = builder.healthCheckCustomConfig;
    }

    /**
     * <p>
     * The name that you want to assign to the service.
     * </p>
     * 
     * @return The name that you want to assign to the service.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the namespace that you want to use to create the service.
     * </p>
     * 
     * @return The ID of the namespace that you want to use to create the service.
     */
    public String namespaceId() {
        return namespaceId;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>CreateService</code> requests to be
     * retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique
     * string, for example, a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>CreateService</code> requests to
     *         be retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can be any
     *         unique string, for example, a date/time stamp.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A description for the service.
     * </p>
     * 
     * @return A description for the service.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon Route 53 records that you want AWS Cloud Map to create
     * when you register an instance.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon Route 53 records that you want AWS Cloud Map to
     *         create when you register an instance.
     */
    public DnsConfig dnsConfig() {
        return dnsConfig;
    }

    /**
     * <p>
     * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional Route 53 health check.
     * If you specify settings for a health check, AWS Cloud Map associates the health check with all the Route 53 DNS
     * records that you specify in <code>DnsConfig</code>.
     * </p>
     * <important>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
     * <code>HealthCheckConfig</code> but not both.
     * </p>
     * </important>
     * <p>
     * For information about the charges for health checks, see <a href="http://aws.amazon.com/cloud-map/pricing/">AWS
     * Cloud Map Pricing</a>.
     * </p>
     * 
     * @return <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional Route 53 health
     *         check. If you specify settings for a health check, AWS Cloud Map associates the health check with all the
     *         Route 53 DNS records that you specify in <code>DnsConfig</code>.</p> <important>
     *         <p>
     *         If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code>
     *         or <code>HealthCheckConfig</code> but not both.
     *         </p>
     *         </important>
     *         <p>
     *         For information about the charges for health checks, see <a
     *         href="http://aws.amazon.com/cloud-map/pricing/">AWS Cloud Map Pricing</a>.
     */
    public HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * A complex type that contains information about an optional custom health check.
     * </p>
     * <important>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
     * <code>HealthCheckConfig</code> but not both.
     * </p>
     * </important>
     * 
     * @return A complex type that contains information about an optional custom health check.</p> <important>
     *         <p>
     *         If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code>
     *         or <code>HealthCheckConfig</code> but not both.
     *         </p>
     */
    public HealthCheckCustomConfig healthCheckCustomConfig() {
        return healthCheckCustomConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckCustomConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(namespaceId(), other.namespaceId())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(description(), other.description()) && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(healthCheckCustomConfig(), other.healthCheckCustomConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateServiceRequest").add("Name", name()).add("NamespaceId", namespaceId())
                .add("CreatorRequestId", creatorRequestId()).add("Description", description()).add("DnsConfig", dnsConfig())
                .add("HealthCheckConfig", healthCheckConfig()).add("HealthCheckCustomConfig", healthCheckCustomConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NamespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DnsConfig":
            return Optional.ofNullable(clazz.cast(dnsConfig()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        case "HealthCheckCustomConfig":
            return Optional.ofNullable(clazz.cast(healthCheckCustomConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceRequest> {
        /**
         * <p>
         * The name that you want to assign to the service.
         * </p>
         * 
         * @param name
         *        The name that you want to assign to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the namespace that you want to use to create the service.
         * </p>
         * 
         * @param namespaceId
         *        The ID of the namespace that you want to use to create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>CreateService</code> requests to be
         * retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique
         * string, for example, a date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed <code>CreateService</code> requests
         *        to be retried without the risk of executing the operation twice. <code>CreatorRequestId</code> can be
         *        any unique string, for example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A description for the service.
         * </p>
         * 
         * @param description
         *        A description for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A complex type that contains information about the Amazon Route 53 records that you want AWS Cloud Map to
         * create when you register an instance.
         * </p>
         * 
         * @param dnsConfig
         *        A complex type that contains information about the Amazon Route 53 records that you want AWS Cloud Map
         *        to create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfig dnsConfig);

        /**
         * <p>
         * A complex type that contains information about the Amazon Route 53 records that you want AWS Cloud Map to
         * create when you register an instance.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsConfig.Builder} avoiding the need to create
         * one manually via {@link DnsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsConfig(DnsConfig)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfig)
         */
        default Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return dnsConfig(DnsConfig.builder().applyMutation(dnsConfig).build());
        }

        /**
         * <p>
         * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional Route 53 health
         * check. If you specify settings for a health check, AWS Cloud Map associates the health check with all the
         * Route 53 DNS records that you specify in <code>DnsConfig</code>.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/cloud-map/pricing/">AWS Cloud Map Pricing</a>.
         * </p>
         * 
         * @param healthCheckConfig
         *        <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional Route 53
         *        health check. If you specify settings for a health check, AWS Cloud Map associates the health check
         *        with all the Route 53 DNS records that you specify in <code>DnsConfig</code>.</p> <important>
         *        <p>
         *        If you specify a health check configuration, you can specify either
         *        <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
         *        </p>
         *        </important>
         *        <p>
         *        For information about the charges for health checks, see <a
         *        href="http://aws.amazon.com/cloud-map/pricing/">AWS Cloud Map Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * <i>Public DNS namespaces only.</i> A complex type that contains settings for an optional Route 53 health
         * check. If you specify settings for a health check, AWS Cloud Map associates the health check with all the
         * Route 53 DNS records that you specify in <code>DnsConfig</code>.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/cloud-map/pricing/">AWS Cloud Map Pricing</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the need to
         * create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }

        /**
         * <p>
         * A complex type that contains information about an optional custom health check.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important>
         * 
         * @param healthCheckCustomConfig
         *        A complex type that contains information about an optional custom health check.</p> <important>
         *        <p>
         *        If you specify a health check configuration, you can specify either
         *        <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig);

        /**
         * <p>
         * A complex type that contains information about an optional custom health check.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link HealthCheckCustomConfig.Builder}
         * avoiding the need to create one manually via {@link HealthCheckCustomConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckCustomConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #healthCheckCustomConfig(HealthCheckCustomConfig)}.
         * 
         * @param healthCheckCustomConfig
         *        a consumer that will call methods on {@link HealthCheckCustomConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckCustomConfig(HealthCheckCustomConfig)
         */
        default Builder healthCheckCustomConfig(Consumer<HealthCheckCustomConfig.Builder> healthCheckCustomConfig) {
            return healthCheckCustomConfig(HealthCheckCustomConfig.builder().applyMutation(healthCheckCustomConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String name;

        private String namespaceId;

        private String creatorRequestId;

        private String description;

        private DnsConfig dnsConfig;

        private HealthCheckConfig healthCheckConfig;

        private HealthCheckCustomConfig healthCheckCustomConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            name(model.name);
            namespaceId(model.namespaceId);
            creatorRequestId(model.creatorRequestId);
            description(model.description);
            dnsConfig(model.dnsConfig);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckCustomConfig(model.healthCheckCustomConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final HealthCheckCustomConfig.Builder getHealthCheckCustomConfig() {
            return healthCheckCustomConfig != null ? healthCheckCustomConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig;
            return this;
        }

        public final void setHealthCheckCustomConfig(HealthCheckCustomConfig.BuilderImpl healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig != null ? healthCheckCustomConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
