/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class InstanceHealthStatusMapCopier {
    static Map<String, String> copy(Map<String, String> instanceHealthStatusMapParam) {
        if (instanceHealthStatusMapParam == null || instanceHealthStatusMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, String> instanceHealthStatusMapParamCopy = instanceHealthStatusMapParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        return Collections.unmodifiableMap(instanceHealthStatusMapParamCopy);
    }

    static Map<String, String> copyEnumToString(Map<String, HealthStatus> instanceHealthStatusMapParam) {
        if (instanceHealthStatusMapParam == null || instanceHealthStatusMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, String> instanceHealthStatusMapParamCopy = instanceHealthStatusMapParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue().toString()), HashMap::putAll);
        return Collections.unmodifiableMap(instanceHealthStatusMapParamCopy);
    }

    static Map<String, HealthStatus> copyStringToEnum(Map<String, String> instanceHealthStatusMapParam) {
        if (instanceHealthStatusMapParam == null || instanceHealthStatusMapParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, HealthStatus> instanceHealthStatusMapParamCopy = instanceHealthStatusMapParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), HealthStatus.fromValue(e.getValue())), HashMap::putAll);
        return Collections.unmodifiableMap(instanceHealthStatusMapParamCopy);
    }
}
