/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DnsRecordListCopier {
    static List<DnsRecord> copy(Collection<DnsRecord> dnsRecordListParam) {
        if (dnsRecordListParam == null || dnsRecordListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<DnsRecord> dnsRecordListParamCopy = new ArrayList<>(dnsRecordListParam);
        return Collections.unmodifiableList(dnsRecordListParamCopy);
    }

    static List<DnsRecord> copyFromBuilder(Collection<? extends DnsRecord.Builder> dnsRecordListParam) {
        if (dnsRecordListParam == null) {
            return null;
        }
        return copy(dnsRecordListParam.stream().map(DnsRecord.Builder::build).collect(toList()));
    }
}
