/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<ListServicesRequest.Builder, ListServicesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListServicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<ServiceFilter>> FILTERS_FIELD = SdkField
            .<List<ServiceFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListServicesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, FILTERS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<ServiceFilter> filters;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * For the first <code>ListServices</code> request, omit this value.
     * </p>
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next
     * group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.
     * </p>
     * <note>
     * <p>
     * AWS Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
     * possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
     * subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.
     * </p>
     * </note>
     * 
     * @return For the first <code>ListServices</code> request, omit this value.</p>
     *         <p>
     *         If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get
     *         the next group of results. Specify the value of <code>NextToken</code> from the previous response in the
     *         next request.
     *         </p>
     *         <note>
     *         <p>
     *         AWS Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified
     *         criteria. It's possible that no services in the first <code>MaxResults</code> services matched the
     *         specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services
     *         that match the criteria.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of services that you want AWS Cloud Map to return in the response to a
     * <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
     * returns up to 100 services.
     * </p>
     * 
     * @return The maximum number of services that you want AWS Cloud Map to return in the response to a
     *         <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud
     *         Map returns up to 100 services.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains specifications for the namespaces that you want to list services for.
     * </p>
     * <p>
     * If you specify more than one filter, an operation must match all filters to be returned by
     * <code>ListServices</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains specifications for the namespaces that you want to list services for. </p>
     *         <p>
     *         If you specify more than one filter, an operation must match all filters to be returned by
     *         <code>ListServices</code>.
     */
    public final List<ServiceFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesRequest, T> g) {
        return obj -> g.apply((ListServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesRequest> {
        /**
         * <p>
         * For the first <code>ListServices</code> request, omit this value.
         * </p>
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
         * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * AWS Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria.
         * It's possible that no services in the first <code>MaxResults</code> services matched the specified criteria
         * but that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        For the first <code>ListServices</code> request, omit this value.</p>
         *        <p>
         *        If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.
         *        </p>
         *        <note>
         *        <p>
         *        AWS Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified
         *        criteria. It's possible that no services in the first <code>MaxResults</code> services matched the
         *        specified criteria but that subsequent groups of <code>MaxResults</code> services do contain services
         *        that match the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of services that you want AWS Cloud Map to return in the response to a
         * <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud Map
         * returns up to 100 services.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of services that you want AWS Cloud Map to return in the response to a
         *        <code>ListServices</code> request. If you don't specify a value for <code>MaxResults</code>, AWS Cloud
         *        Map returns up to 100 services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the namespaces that you want to list services for.
         *        </p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListServices</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ServiceFilter> filters);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * 
         * @param filters
         *        A complex type that contains specifications for the namespaces that you want to list services for.
         *        </p>
         *        <p>
         *        If you specify more than one filter, an operation must match all filters to be returned by
         *        <code>ListServices</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ServiceFilter... filters);

        /**
         * <p>
         * A complex type that contains specifications for the namespaces that you want to list services for.
         * </p>
         * <p>
         * If you specify more than one filter, an operation must match all filters to be returned by
         * <code>ListServices</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ServiceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ServiceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ServiceFilter>)
         */
        Builder filters(Consumer<ServiceFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<ServiceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final List<ServiceFilter.Builder> getFilters() {
            List<ServiceFilter.Builder> result = ServiceFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<ServiceFilter> filters) {
            this.filters = ServiceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ServiceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ServiceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ServiceFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ServiceFilter.BuilderImpl> filters) {
            this.filters = ServiceFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
