/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * With AWS Cloud Map, you can configure public DNS, private DNS, or HTTP namespaces that your microservice applications
 * run in. When an instance becomes available, you can call the AWS Cloud Map API to register the instance with AWS
 * Cloud Map. For public or private DNS namespaces, AWS Cloud Map automatically creates DNS records and an optional
 * health check. Clients that submit public or private DNS queries, or HTTP requests, for the service receive an answer
 * that contains up to eight healthy records.
 * </p>
 */
package software.amazon.awssdk.services.servicediscovery;