/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation is already in progress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DuplicateRequestException extends ServiceDiscoveryException implements
        ToCopyableBuilder<DuplicateRequestException.Builder, DuplicateRequestException> {
    private static final SdkField<String> DUPLICATE_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DuplicateOperationId").getter(getter(DuplicateRequestException::duplicateOperationId))
            .setter(setter(Builder::duplicateOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DuplicateOperationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUPLICATE_OPERATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String duplicateOperationId;

    private DuplicateRequestException(BuilderImpl builder) {
        super(builder);
        this.duplicateOperationId = builder.duplicateOperationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The ID of the operation that's already in progress.
     * </p>
     * 
     * @return The ID of the operation that's already in progress.
     */
    public String duplicateOperationId() {
        return duplicateOperationId;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DuplicateRequestException, T> g) {
        return obj -> g.apply((DuplicateRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DuplicateRequestException>,
            ServiceDiscoveryException.Builder {
        /**
         * <p>
         * The ID of the operation that's already in progress.
         * </p>
         * 
         * @param duplicateOperationId
         *        The ID of the operation that's already in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duplicateOperationId(String duplicateOperationId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ServiceDiscoveryException.BuilderImpl implements Builder {
        private String duplicateOperationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DuplicateRequestException model) {
            super(model);
            duplicateOperationId(model.duplicateOperationId);
        }

        public final String getDuplicateOperationId() {
            return duplicateOperationId;
        }

        @Override
        public final Builder duplicateOperationId(String duplicateOperationId) {
            this.duplicateOperationId = duplicateOperationId;
            return this;
        }

        public final void setDuplicateOperationId(String duplicateOperationId) {
            this.duplicateOperationId = duplicateOperationId;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DuplicateRequestException build() {
            return new DuplicateRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
