/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstancesHealthStatusRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<GetInstancesHealthStatusRequest.Builder, GetInstancesHealthStatusRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(GetInstancesHealthStatusRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(GetInstancesHealthStatusRequest::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetInstancesHealthStatusRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInstancesHealthStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            INSTANCES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String serviceId;

    private final List<String> instances;

    private final Integer maxResults;

    private final String nextToken;

    private GetInstancesHealthStatusRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.instances = builder.instances;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the service that the instance is associated with.
     * </p>
     * 
     * @return The ID of the service that the instance is associated with.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the IDs of all the instances that you want to get the health status for.
     * </p>
     * <p>
     * If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are associated
     * with the specified service.
     * </p>
     * <note>
     * <p>
     * To get the IDs for the instances that you've registered by using a specified service, submit a <a
     * href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the IDs of all the instances that you want to get the health status for.</p>
     *         <p>
     *         If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are
     *         associated with the specified service.
     *         </p>
     *         <note>
     *         <p>
     *         To get the IDs for the instances that you've registered by using a specified service, submit a <a
     *         href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.
     *         </p>
     */
    public final List<String> instances() {
        return instances;
    }

    /**
     * <p>
     * The maximum number of instances that you want Cloud Map to return in the response to a
     * <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud
     * Map returns up to 100 instances.
     * </p>
     * 
     * @return The maximum number of instances that you want Cloud Map to return in the response to a
     *         <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>,
     *         Cloud Map returns up to 100 instances.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * For the first <code>GetInstancesHealthStatus</code> request, omit this value.
     * </p>
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     * <code>NextToken</code> from the previous response in the next request.
     * </p>
     * 
     * @return For the first <code>GetInstancesHealthStatus</code> request, omit this value.</p>
     *         <p>
     *         If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesHealthStatusRequest)) {
            return false;
        }
        GetInstancesHealthStatusRequest other = (GetInstancesHealthStatusRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstancesHealthStatusRequest").add("ServiceId", serviceId())
                .add("Instances", hasInstances() ? instances() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstancesHealthStatusRequest, T> g) {
        return obj -> g.apply((GetInstancesHealthStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInstancesHealthStatusRequest> {
        /**
         * <p>
         * The ID of the service that the instance is associated with.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service that the instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * An array that contains the IDs of all the instances that you want to get the health status for.
         * </p>
         * <p>
         * If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are
         * associated with the specified service.
         * </p>
         * <note>
         * <p>
         * To get the IDs for the instances that you've registered by using a specified service, submit a <a
         * href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.
         * </p>
         * </note>
         * 
         * @param instances
         *        An array that contains the IDs of all the instances that you want to get the health status for.</p>
         *        <p>
         *        If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are
         *        associated with the specified service.
         *        </p>
         *        <note>
         *        <p>
         *        To get the IDs for the instances that you've registered by using a specified service, submit a <a
         *        href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a>
         *        request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p>
         * An array that contains the IDs of all the instances that you want to get the health status for.
         * </p>
         * <p>
         * If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are
         * associated with the specified service.
         * </p>
         * <note>
         * <p>
         * To get the IDs for the instances that you've registered by using a specified service, submit a <a
         * href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a> request.
         * </p>
         * </note>
         * 
         * @param instances
         *        An array that contains the IDs of all the instances that you want to get the health status for.</p>
         *        <p>
         *        If you omit <code>Instances</code>, Cloud Map returns the health status for all the instances that are
         *        associated with the specified service.
         *        </p>
         *        <note>
         *        <p>
         *        To get the IDs for the instances that you've registered by using a specified service, submit a <a
         *        href="https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html">ListInstances</a>
         *        request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p>
         * The maximum number of instances that you want Cloud Map to return in the response to a
         * <code>GetInstancesHealthStatus</code> request. If you don't specify a value for <code>MaxResults</code>,
         * Cloud Map returns up to 100 instances.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of instances that you want Cloud Map to return in the response to a
         *        <code>GetInstancesHealthStatus</code> request. If you don't specify a value for
         *        <code>MaxResults</code>, Cloud Map returns up to 100 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * For the first <code>GetInstancesHealthStatus</code> request, omit this value.
         * </p>
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        For the first <code>GetInstancesHealthStatus</code> request, omit this value.</p>
         *        <p>
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String serviceId;

        private List<String> instances = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesHealthStatusRequest model) {
            super(model);
            serviceId(model.serviceId);
            instances(model.instances);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceId() {
            return serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Collection<String> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstancesHealthStatusRequest build() {
            return new GetInstancesHealthStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
